<%--
    Copyright (c) 2005 Sun Microsystems, Inc. All rights reserved
    Use is subject to license terms.
--%>



<%@page
import="java.io.*,javax.xml.soap.SOAPMessage,org.w3c.dom.Element,org.w3c.dom.Document,com.iplanet.am.util.XMLUtils,com.sun.identity.federation.common.FSUtils,com.sun.identity.federation.common.IFSConstants,com.sun.identity.saml.assertion.NameIdentifier,com.sun.identity.federation.message.FSNameIdentifierMappingRequest,com.sun.identity.federation.message.FSNameIdentifierMappingResponse,com.sun.identity.federation.services.FSSOAPService,com.sun.identity.federation.services.FSSession,com.sun.identity.federation.services.FSSessionManager,com.sun.identity.federation.services.FSSessionPartner,com.sun.identity.federation.services.util.FSServiceUtils,com.sun.identity.federation.services.namemapping.FSNameMappingHandler,com.sun.identity.federation.alliance.FSProviderDescriptor,com.sun.liberty.LibertyManager,com.iplanet.sso.*,com.sun.identity.saml.common.SAMLUtils" %>
<html xmlns="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<head><title>Sending NameIdentifierMappingRequest</title></head>
<%
    if (request.getMethod().equals("POST")) {

	if (FSUtils.debug.messageEnabled()) {
	    FSUtils.debug.message(
		"entering NameMappingRequester");
	}
        String metaAlias = 
	       request.getParameter(IFSConstants.META_ALIAS);
        if (metaAlias==null || metaAlias.length()==0) {
	    FSUtils.debug.message("NameMappingRequester: metaAlias=" + 
							 metaAlias);
	    %>
	       <body bgcolor="white">No MetaAlias in request. Cannot procceed.</body></html>
	    <%
            return;
        }

	SSOTokenManager manager = null;
	SSOToken ssoToken = null;
        try {
            manager = SSOTokenManager.getInstance();
            ssoToken = manager.createSSOToken(request);
            if (!manager.isValidToken(ssoToken)) {
	        %>
		    <body bgcolor="white">SSO Token is not valid.</body></html>
		<%
		return;
            }
        } catch (com.iplanet.sso.SSOException e){
	    %>
	    <body bgcolor="white">SSOException caught when trying to create
	    SSO Token from HTTP request: <%= e.getMessage() %></body></html>
	    <%
	    return;
	}

	String targetNamespace =
	    request.getParameter("targetNameSpace");

	NameIdentifier retNI = LibertyManager.getMappedNameIdentifier(
	    metaAlias, ssoToken, targetNamespace);

	if (retNI == null) {
	    %>
	    <body bgcolor="white">Could not obtain the mapped name identifier,
            see debug file for details</body></html>
	    <%
	    return;
	}
	try {
	    String nameIdStr = retNI.toString();

	    if (FSUtils.debug.messageEnabled()) {
		FSUtils.debug.message(
		    "Received Name Identifier="+
		    nameIdStr);
	    }
	    if (retNI.getFormat() != null &&
		retNI.getFormat().equals(IFSConstants.NI_ENCRYPTED_FORMAT_URI)) {

		nameIdStr = retNI.toString(true,true);

		String decryptionURL = request.getParameter("decryptionURL");
		
		if (FSUtils.debug.messageEnabled()) {
		    FSUtils.debug.message("Decryption URL is "+
					  decryptionURL);
		}					    

		if (decryptionURL==null || decryptionURL.length()==0) {
		   %>
			Decryption URL is missing. Please fill it in.
		   <%
		   return;
                }
		%>
		    <BODY bgcolor="white" Onload="document.forms[0].submit()">
		    <H1>Response Received</H1>
			You are being redirected to the target SP for Decryption.
			Please wait ......
			<FORM METHOD="POST" ACTION="<%= decryptionURL %>">
			    <INPUT TYPE="HIDDEN" NAME="ni"
						 VALUE="<%= SAMLUtils.HTMLEncode(nameIdStr,'\"') %>">
			    <INPUT TYPE="HIDDEN" NAME="targetNameSpace"
						 VALUE="<%= targetNamespace %>">
			</FORM>
		    </BODY>
		    </html>
		<%
		return;
	    } else {

		nameIdStr = SAMLUtils.HTMLEncode(nameIdStr,'<');
                nameIdStr = SAMLUtils.HTMLEncode(nameIdStr,'>');
	
	        %>
		<body bgcolor="white"><pre>

The mapped name identifier in the target name space is:

<%= nameIdStr %>

		</pre></body></html>
		<%
		return;
	    }	
	} catch (Exception e) {
	    FSUtils.debug.error("FSNameMappingRequester: ", e);
	    %>
	    <body bgcolor="white">Got exception: <%= e.getMessage() %></body></html>
	    <%
	    return;	    
	}
    } 
%>
 
