/**
 * $Id: UserProfileViewBean.java,v 1.5 2005/06/24 16:50:36 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


package com.iplanet.am.console.user;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.TextField;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.user.model.UMUserProfileModel;
import com.iplanet.am.util.Debug;

/**
* Sample viewbean that demonstrates how to customize the user profile 
* display.
*/
public class UserProfileViewBean extends UMUserProfileViewBean {

    Debug debug = Debug.getInstance("amConsole");

    /** name of view bean */
    public static final String PAGE_NAME = "UserProfile";

    /** display URL of view bean */
    public static final String DEFAULT_DISPLAY_URL
        = "/console/user/UserProfile.jsp";

    public static final String FIRST_NAME = "givenname";
    public static final String LAST_NAME = "sn";
    public static final String ADDRESS = "postaladdress";
    public static final String PHONE = "telephonenumber";
    public static final String EMAIL = "mail";
    public static final String EMPLOYEE_NUMBER = "employeenumber";

    private String [] attributes = { 
	"givenname", 
	"sn", 
	"postaladdress", 
	"telephonenumber", 
	"mail", 
	"employeenumber" 
    };

    public UserProfileViewBean() {
        super(PAGE_NAME,DEFAULT_DISPLAY_URL);
    }

    protected View createChild(String name) {
        if (name.equals(ADDRESS)) {
            return new TextField(this, ADDRESS, "");
        }
        if (name.equals(FIRST_NAME)) {
            return new TextField(this, FIRST_NAME, "");
        }
        if (name.equals(LAST_NAME)) {
            return new TextField(this, LAST_NAME, "");
        }
        if (name.equals(ADDRESS)) {
            return new TextField(this, ADDRESS, "");
        }
        if (name.equals(PHONE)) {
            return new TextField(this, PHONE, "");
        }
        if (name.equals(EMAIL)) {
            return new TextField(this, EMAIL, "");
        }
        if (name.equals(EMPLOYEE_NUMBER)) {
            return new TextField(this, EMPLOYEE_NUMBER, "");
        }
        return super.createChild(name);
    }

    protected void registerChildren() {
        registerChild(FIRST_NAME, TextField.class);
        registerChild(LAST_NAME, TextField.class);
        registerChild(ADDRESS, TextField.class);
        registerChild(EMAIL, TextField.class);
        registerChild(PHONE, TextField.class);
        registerChild(EMPLOYEE_NUMBER, TextField.class);
        super.registerChildren();
    }

    public void beginDisplay(DisplayEvent event)
        throws ModelControlException
    {
	super.beginDisplay(event);

	UMUserProfileModel model = getModel();

	for (int x=0; x < attributes.length; x++) {
	    Set tmp = model.getAttributeValues(0,attributes[x]);
	    String value = "";
	    if (tmp != null && tmp.size() > 0) {
	        value = (String)tmp.iterator().next();
	    }
	    setDisplayFieldValue(attributes[x],value);
        }

    }

    /**
     * handles form submission request
     *
     * @param event request invocation event
     */
    public void handleBtnSubmitRequest(RequestInvocationEvent event) {
        RequestContext rc = getRequestContext();
        HttpServletRequest req = rc.getRequest();
        UMUserProfileModel model = getModel(req);

	Map values = new HashMap(attributes.length);

	for (int x=0; x < attributes.length; x++) {
            Set attrValues = new HashSet(1);
            String tmp = (String)getDisplayFieldValue(attributes[x]);
            attrValues.add(tmp);
            values.put(attributes[x],attrValues);
	}

        try {
            // need to set the attribute status
	    model.setAttributeStatus(null);

            // set the new values in the model 
            model.setAttributeValues(values);

	    // store the new values
            model.updateProfile();
        } catch (AMConsoleException ace) {
            debug.error("failed to set attributes for user" , ace);
        }

        forwardTo();
    }
}
