/**
 * $Id: SamplePasswordGenerator.java,v 1.7 2005/06/24 16:50:33 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


package com.iplanet.am.console.user;

import com.iplanet.am.util.Debug;
import com.iplanet.am.sdk.AMUser;
import com.sun.identity.password.plugins.PasswordGenerator;
import com.sun.identity.password.ui.model.PWResetException;

/**
 * <code>SamplePasswordGenerator</code> is sample plugin implementation to show
 * that how customer can write their own password generation mechanism after the
 * password is reset. It is based on the public interface 
 * <code>PasswordGenerator</code>. This plugin is called(after configuring it 
 * in Access Manager console by the "Password Reset" module to generate the new
 * password after resetting the old password of the user. Access Manager comes
 * with a default plugin implementation as well. The default plugin generates
 * random passwords.
 */
public class SamplePasswordGenerator implements PasswordGenerator 
{

    /**
     * Get a handle of the debug file.
     */
    private static Debug debug = Debug.getInstance("amConsole");



    /**
     * Constructs a random password generator object.
     */
    public SamplePasswordGenerator() {
    }
    
   
    /**
     * Generates new password for user.
     *
     * @param user <code>AMUser</code> object
     * @return new password for user
     * @throws PWResetException if password cannot be generated.
     */
    public String generatePassword(AMUser user) throws PWResetException {
        
        String newpassword = null;

        debug.message(
	    "User password has been reset and a new password will be generated."
	    );
        
        /*
         * Put your own logic to create a new password for the user whose 
         * password has been reset through the "Password Reset" module. 
	 * For the sample purpose the new password has been put here as
	 * "changeit"
         */
        newpassword = "changeit";
                
        debug.message(" User password  has changed to -" + newpassword);
        return newpassword;
    }
}
