/**
 * $Id: UMRelocateUserViewBean.java,v 1.5 2005/06/24 16:50:25 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


package com.iplanet.am.console.user;

import com.iplanet.am.console.base.AMViewBeanBase;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.am.console.components.view.html.IPlanetButton;
import com.iplanet.jato.view.html.TextField;
import javax.servlet.http.HttpServletRequest;
import java.util.List;
import com.iplanet.am.console.base.model.AMClassCacher;
import com.iplanet.am.console.user.model.UMRelocateUserModel;
import com.iplanet.am.console.user.model.UMRelocateUserModelImpl;
import java.io.IOException;
import java.util.StringTokenizer;

public class UMRelocateUserViewBean extends AMViewBeanBase {

    public static final String UID = "uid";
    public static final String USERDN_EXAMPLE = "userdn_example";
    public static final String ORGDN_EXAMPLE = "newOrgDn_example";
    public static final String NEW_ORGDN = "newOrgDn"; 
    public static final String UID_TEXT = "uid_text";
    public static final String NEW_ORGDN_TEXT = "newOrgDn_text";
    public static final String SUBMIT_BUTTON = "btnSubmit";
    public static final String CANCEL_BUTTON = "btnCancel";
    public static final String PAGE_NAME = "UMRelocateUser";   
    public final String CREATE_TITLE = "createTitle";
    public static final String DEFAULT_DISPLAY_URL =
        "/console/user/UMRelocateUser.jsp";

    protected UMRelocateUserModel model = null;
    public  boolean reloadFrames = false;
    protected String RELOAD_NAV_FRAME = "reloadFlag";
    public String orgDN = "";

    /**
     * constructor
     *
     */
    public UMRelocateUserViewBean() {
        super(PAGE_NAME);
        setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        registerChildren();
    }

    /**
     * registers child components/views
     */
    protected void registerChildren() {
        super.registerChildren();
        registerChild(UID, StaticTextField.class);
        registerChild(UID_TEXT, TextField.class);
        registerChild(USERDN_EXAMPLE, StaticTextField.class);
        registerChild(ORGDN_EXAMPLE, StaticTextField.class);
        registerChild(NEW_ORGDN, StaticTextField.class);
        registerChild(NEW_ORGDN_TEXT, TextField.class);
        registerChild(SUBMIT_BUTTON, IPlanetButton.class);
        registerChild(CANCEL_BUTTON, IPlanetButton.class);
        registerChild(CREATE_TITLE, StaticTextField.class);
    }

    /**
     * creates child component
     *
     * @param name of child component
     * @return child component
     */
    protected View createChild(String name) {
        View child = null;
        if (name.equals(UID)) {
            child = new StaticTextField(this, UID, "");
        } else if (name.equals(UID_TEXT)) {
            child = new TextField(this, UID_TEXT, "");
        } else if (name.equals(USERDN_EXAMPLE)) {
            child = new StaticTextField(this, USERDN_EXAMPLE, "");
        } else if (name.equals(ORGDN_EXAMPLE)) {
            child = new StaticTextField(this, ORGDN_EXAMPLE, "");
        } else if (name.equals(NEW_ORGDN)) {
            child = new StaticTextField(this, NEW_ORGDN, "");
        } else if (name.equals(NEW_ORGDN_TEXT)) {
            child = new TextField(this, NEW_ORGDN_TEXT, "");
        } else if (name.equals(SUBMIT_BUTTON)) {
            child = new IPlanetButton(this, SUBMIT_BUTTON, "");
        } else if (name.equals(CANCEL_BUTTON)) {
            child = new IPlanetButton(this, CANCEL_BUTTON, "");
        } else if (name.equals(CREATE_TITLE)) {
            child = new StaticTextField(this, CREATE_TITLE, "");
        } else {
            child = super.createChild(name);
        }
        return child;
    }




    /**
     * begins displaying page. we set the required information
     *
     * @param event   display event
     * @throws ModelControlException  if problem access value of component
     */
    public void beginDisplay(DisplayEvent event)
        throws ModelControlException {
        super.beginDisplay(event);
        model = (UMRelocateUserModel) getModel(
	    getRequestContext().getRequest());
        setChildValues(model);
        setDisplayFieldValue(CREATE_TITLE, model.getTitle());
        setDisplayFieldValue(UID, model.getUIDLabel());
        setDisplayFieldValue(USERDN_EXAMPLE, model.getUserdnExample());
        setDisplayFieldValue(ORGDN_EXAMPLE, model.getOrgDNExample());
        setDisplayFieldValue(NEW_ORGDN, model.getNewOrgDNLabel());
        setDisplayFieldValue(UID_TEXT,"");
        setDisplayFieldValue(NEW_ORGDN_TEXT,"");
        setDisplayFieldValue(SUBMIT_BUTTON, "Submit");
        setDisplayFieldValue(CANCEL_BUTTON, "Cancel");
    }

    /**
     * handles form submission request
     *
     * @param event request invocation event
     */
    public void handleBtnSubmitRequest(RequestInvocationEvent event) {
        RequestContext rc = getRequestContext();
        HttpServletRequest req = rc.getRequest();
         String userDn = (String)getDisplayFieldValue(UID_TEXT);
         String newOrgDn = (String)getDisplayFieldValue(NEW_ORGDN_TEXT);
 
         StringTokenizer st = new StringTokenizer(userDn, ",");
         int count = 1;
         StringBuffer sb = new StringBuffer(50);

         while (st.hasMoreTokens()) {
             if (count <= 2) {
                 st.nextToken();
             } else {
                   sb.append((String)st.nextToken());
                   if (st.hasMoreTokens()) {
                       sb.append(",");
                   }
             }
             count++;
         }
         orgDN = sb.toString();
         getModel(req);
         model.moveUser(userDn, newOrgDn);
         setLocationDN(orgDN);
         setPageSessionAttribute(RELOAD_NAV_FRAME, "true");
         forwardTo();
    }

    /**
     * get model for this view bean
     *
     * @param req HTTP servlet request
     * @return model for this view bean
     */
    protected UMRelocateUserModel getModel(HttpServletRequest req) {
        if (model == null) {
            model = new UMRelocateUserModelImpl (
                req, getPageSessionAttributes());
        }
        return model;
    }
  
    /**
    * This determines if the navigation frame should be redisplayed
    * The value of reload is determined by whether or not the object
    * create succeeded or failed. If the object was created
    * <code>reloadFrames</code> is set to true.
    */
    public boolean beginFrameReloadDisplay(ChildDisplayEvent cde) {
        String reload = (String)
            getPageSessionAttribute(RELOAD_NAV_FRAME);
        if (reload != null && reload.equals ("true")) {
            reloadFrames = true;
            removePageSessionAttribute(RELOAD_NAV_FRAME);
        }
        return reloadFrames;
    }

    /**
     * handles form cancel request
     *
     * @param event request invocation event
     */
    public void handleBtnCancelRequest(RequestInvocationEvent event)
        throws ModelControlException {
        RequestContext rc = getRequestContext();
        HttpServletRequest request = rc.getRequest();
        model = getModel(request);

        boolean forwarded = false;
        List vbList = (List)getPageSessionAttribute(CANCEL_VB_NAME_LIST);
        if (vbList != null && !vbList.isEmpty()) {
            int size = vbList.size();
            String vbName = (String)vbList.remove(size-1);
            if (vbName != null && vbName.length() != 0) {
                Class vbClass = null;
                try {
                    vbClass =
                        AMClassCacher.getInstance().getClassObject(vbName);
                } catch (ClassNotFoundException e){
                    model.debugError(
                        "UMUserViewBeanBase.handleCancelButtonRequest:" + e);
                }

                AMViewBeanBase umVB =
                    (AMViewBeanBase) getViewBean(vbClass);
                passPgSessionMap(umVB);
                umVB.forwardTo(rc);
                forwarded = true;
                return;
            }
        }
        try {
            rc.getResponse().sendRedirect(getBlankHtmlURL(model));
            forwarded = true;
        } catch (IOException ioe) {
            model.debugError(
                "UMCreateUserViewBean.handleCancelButtonRequest", ioe);
        }
        finally {
            if (!forwarded) {
                forwardTo();
            }
        }

    }

}
