/**
 * $Id: ConsoleEventListener.java,v 1.8 2005/06/24 16:50:23 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


package com.iplanet.am.console.base.model;

import com.iplanet.am.sdk.AMObject;
import com.sun.identity.sm.SchemaType;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConsoleEventListener extends AMConsoleListenerAdapter {

    /**
     * This method is called before displaying a module tab in the header view
     *
     * @param model implementation class initiates this event
     * @param moduleName   name of module
     * @return true to display this tab, false otherwises
     */
    public boolean onBeforeDisplayModuleTab(AMModel model, String moduleName) {
	AMModelBase.debug.message("onBeforeDisplayModuleTab");
	AMModelBase.debug.message("module name:" + moduleName);
	return true;
    }

    /**
     * This method is called before creating an object.
     * <code>AttributeValues</code> maps attribute name (String) to its values.
     * Alter this map to have different values for the new object
     *
     * @param model implementation class initiates this event
     * @param objectType - type of object
     * @param container where object is to be created
     * @param name of new object
     * @param attributeValues maps name of attribute (String) to its values
     *       (Set)
     * @throws AMConsoleException will stop the creation of object
     */
    public void onBeforeCreateObject(
	AMModel model,
	int objectType,
	AMObject container,
	String name,
	Map attributeValues)
	throws AMConsoleException
    {
	AMModelBase.debug.message("onBeforeCreateObject");
	AMModelBase.debug.message("object type:" + objectType);
	AMModelBase.debug.message("container:" + container.getDN());
	AMModelBase.debug.message("name:" + name);
	printMap(attributeValues);
    }

    private void printMap(Map map) {
	for (Iterator i = map.keySet().iterator(); i.hasNext(); ) {
	    String key = (String)i.next();
	    AMModelBase.debug.message("" + key);

	    Set values = (Set)map.get(key);
	    if ((values != null) && !values.isEmpty()) {
		String v = "";
		for (Iterator j = values.iterator(); j.hasNext();) {
		    v += (String)j.next();
		}
		AMModelBase.debug.message(v);
	    } else {
		AMModelBase.debug.message("no values");
	    }
	}
    }

    /**
     * This method is called after object is created
     *
     * @param model implementation class initiates this event
     * @param object - newly created object
     */
    public void onAfterCreateObject(AMModel model, AMObject object) {
	AMModelBase.debug.message("onAfterCreateObject");
	AMModelBase.debug.message("object dn:" + object.getDN());
    }

    /**
     * This method is called before deleting an object.
     *
     * @param model implementation class initiates this event
     * @param objectType - type of object
     * @param locationDN of object to be deleted
     * @throws AMConsoleException will stop the deletion of object
     */
    public void onBeforeDeleteObject(
        AMModel model,
        int objectType,
        String locationDN)
	throws AMConsoleException
    {
	AMModelBase.debug.message("onBeforeDeleteObject");
	AMModelBase.debug.message("object type:" + objectType);
	AMModelBase.debug.message("location dn:" + locationDN);
    }

    /**
     * This method is called after an object is deleted.
     *
     * @param model implementation class initiates this event
     * @param objectType - type of object
     * @param locationDN of deleted object
     */
    public void onAfterDeleteObject(
        AMModel model,
        int objectType,
        String locationDN)
    {
	AMModelBase.debug.message("onAfterDeleteObject");
	AMModelBase.debug.message("object type:" + objectType);
	AMModelBase.debug.message("location dn:" + locationDN);
    }

    /**
     * This method is called before updating attribute of an object.
     * <code>AttributeValues</code> maps attribute name (String) to its values.
     * Alter this map to have different values for the object
     *
     * @param model implementation class initiates this event
     * @param objectType - type of object
     * @param object of which attributes are to be updated
     * @param attributeValues maps name of attribute (String) to its values
     *       (Set)
     * @throws AMConsoleException will prevent updating of attributes
     */
    public void onBeforeUpdateValues(
	AMModel model,
	int objectType,
	AMObject object,
	Map attributeValues)
	throws AMConsoleException
    {
        AMModelBase.debug.message("onBeforeUpdateValues");
        AMModelBase.debug.message("object type:" + objectType);
        printMap(attributeValues);
    }

    /**
     * This method is called after attributes of object is update
     *
     * @param model implementation class initiates this event
     * @param objectType - type of object
     * @param object - updated object
     */
    public void onAfterUpdateValues(
	AMModel model,
	int objectType,
	AMObject object)
    {
        AMModelBase.debug.message("onAfterUpdateValues");
        AMModelBase.debug.message("object type:" +  objectType);
    }

    /**
     * Notifies all listeners on before updating default attributes of a
     * service. <code>AttributeValues</code> maps attribute name (String)
     * to its values.
     *
     * @param model implementation class initiates this event
     * @param name of service
     * @param attributeValues maps name of attribute (String) to its values
     *       (Set)
     * @throws AMConsoleException will prevent updating of attributes
     */
    public void onBeforeUpdateDefaultServiceValues(
	AMModel model,
	String name,
	Map attributeValues)
	throws AMConsoleException
    {
	AMModelBase.debug.message("onBeforeUpdateDefaultServiceValues");
	AMModelBase.debug.message("service name:" + name);
        printMap(attributeValues);
    }

    /**
     * This method is called after updating default attributes of a service
     *
     * @param model implementation class initiates this event
     * @param name of service
     */
    public void onAfterUpdateDefaultServiceValues(AMModel model, String name) {
	AMModelBase.debug.message("onAfterUpdateDefaultServiceValues");
	AMModelBase.debug.message("service name:" + name);
    }

    /**
     * This method is called after we have retrieve the values of attributes
     * to be displayed in the creation/profile view.
     * <code>attributeValues</code> maps name of attribute (String) to its
     * values (Set). Alter this map to changes the values of attributes.
     *
     * @param model implementation class initiates this event
     * @param object of which attribute values are retrieved.
     *        <code>object</code> is <code>null</code> if <code>action</code>
     *        equals <code>MODE_CREATION</code>, or retrieve value for global
     *        service.
     * @param action either <code>MODE_CREATION</code> or
     *        <code>MODE_MODIFICATION</code>.
     * @param objectType type of object
     * @param serviceName name of service
     * @param schemaType type of schema.
     * @param attributeValues maps name of attribute (String) to its values
     *       (Set)
     */
    public void onRetrieveAttributeValues(
	AMModel model,
	AMObject object,
	int action,
	int objectType,
	String serviceName,
	SchemaType schemaType,
	Map attributeValues)
    {
        AMModelBase.debug.message("onRetrieveAttributeValues");
        AMModelBase.debug.message((object != null) ? object.getDN() : "null");
        AMModelBase.debug.message("object type:"  + objectType);
        AMModelBase.debug.message("action:" + action);
        AMModelBase.debug.message("service name:" + serviceName);
        AMModelBase.debug.message("schema type:" + schemaType.toString());
        printMap(attributeValues);
    }
}
