//  ident "@(#)policy.js-src	1.21 04/05/11 SMI"
//  Copyright 1999-2002 Sun Microsystems, Inc.  All rights reserved.
//  JavaScript library for managing policy UI interactivity.
// Consult the source tree for a fully-commented precursor to this file.
function handleChange (control) {
   var i;
   var theForm = control.form;
   if (control.name == "scope") {
	if (control.value == "global") {
		reflectPolicy(theForm, theForm.group_policy.value);
	} else {
		reflectPolicy(theForm, theForm.local_policy.value);
	}
   } else if (control.name == "acc_type") {
	if (control.value == "all") {
	   for (i = 0; i < theForm.elements.length; i++) {
		if (theForm.elements[i].name == "acc_type" &&
			theForm.elements[i].value == "reg") {
		   theForm.elements[i].checked = false;
		   theForm.self_reg.checked = false;
		   if (theForm.z_self_reg.checked == false)
		   	theForm.sol_auth.checked = false;
		}
	   }
	} else if (control.value == "reg") {
           if (theForm.self_reg.value == "true") {
                theForm.self_reg.checked = true;
           	if (theForm.sol_auth.value == "true")
                   theForm.sol_auth.checked = true;
           }
	} else if (control.value == "none") {
           for (i = 0; i < theForm.elements.length; i++) {
                if (theForm.elements[i].name == "acc_type" && theForm.elements[i].value == "none") {
                	theForm.elements[i].checked = true;
                        theForm.self_reg.checked = false;
                   if (theForm.z_self_reg.checked == false)
                        theForm.sol_auth.checked = false;
                }
                if (theForm.elements[i].name == "z_acc_type" &&
                        theForm.elements[i].value == "none" &&
                        theForm.elements[i].checked == true) {
                   for (j=0; j<theForm.elements.length; j++) {
                        if (theForm.elements[j].name == "z_acc_type" && theForm.elements[j].value == "all") {
  	                    	theForm.elements[j].checked = true;
                        }
                   }
                }
		if (theForm.elements[i].name == "kiosk" && theForm.elements[i].checked == true) {
                        theForm.elements[i].checked = false;
                        theForm.elements[i].value = "false";
                }
           }
	}
   } else if (control.name == "z_acc_type") {
        if (control.value == "all") {
           for (i=0; i < theForm.elements.length; i++) {
                if (theForm.elements[i].name == "z_acc_type" &&
                        theForm.elements[i].value == "reg") {
                   theForm.elements[i].checked = false;
                   theForm.z_self_reg.checked = false;
		   if (theForm.self_reg.checked == false)
                   	theForm.sol_auth.checked = false;
                }
           }
        } else if (control.value == "reg") {
	   if (theForm.z_self_reg.value == "true") {
		theForm.z_self_reg.checked = true;
	   	if (theForm.sol_auth.value == "true")
		   theForm.sol_auth.checked = true;
	   }
	} else if (control.value == "none") {
           for (i = 0; i < theForm.elements.length; i++) {
                if (theForm.elements[i].name == "z_acc_type" && theForm.elements[i].value == "none") {
                	theForm.elements[i].checked = true;
                        theForm.z_self_reg.checked = false;
                   if (theForm.self_reg.checked == false)
                        theForm.sol_auth.checked = false;
                }
                if (theForm.elements[i].name == "acc_type" &&
                        theForm.elements[i].value == "none" &&
                        theForm.elements[i].checked == true) {
                   for (j=0; j<theForm.elements.length; j++) {
                        if (theForm.elements[j].name == "acc_type" && theForm.elements[j].value == "all") {
  	                    	theForm.elements[j].checked = true;
                        }
                   }
                }
		if (theForm.elements[i].name == "mobile" && theForm.elements[i].checked == true) {
                        theForm.elements[i].checked = false;
                        theForm.elements[i].value = "false";
                }
		if (theForm.elements[i].name == "escape" && theForm.elements[i].checked == true) {
                        theForm.elements[i].checked = false;
                        theForm.elements[i].value = "false";
                }
		if (theForm.elements[i].name == "z_kiosk" && theForm.elements[i].checked == true) {
                        theForm.elements[i].checked = false;
                        theForm.elements[i].value = "false";
                }
           }
	}
   } else if (control.name == "self_reg") {
	if (control.checked == true) {
	   control.value = "true";
	   selectRadioButton(theForm,"acc_type","all",false);
	   selectRadioButton(theForm,"acc_type","reg",true);
	   selectRadioButton(theForm,"acc_type","none",false);
	}
	else {
	   control.value = "false";
	   if (theForm.z_self_reg.checked == false) {
	       theForm.sol_auth.checked = false;
	       theForm.sol_auth.value = "false";
	   }
	}
   } else if (control.name == "z_self_reg") {
        if (control.checked == true) {
           control.value = "true";
           selectRadioButton(theForm,"z_acc_type","all",false);
           selectRadioButton(theForm,"z_acc_type","reg",true);
	   selectRadioButton(theForm,"z_acc_type","none",false);
        }
        else {
           control.value = "false";
	   if (theForm.self_reg.checked == false) {
               theForm.sol_auth.checked = false;
               theForm.sol_auth.value = "false";
	   }
        }
   } else if (control.name == "mobile") {
        checkNone = getFormElement(theForm, "z_acc_type", "none");
	checkEscapeTrue = getFormElement(theForm, "escape", "true");
	checkEscapeFalse = getFormElement(theForm, "escape", "false");
        if (checkNone.checked == true) {
                control.checked = false;
                control.value = "false";
                return;
        }
        if (control.checked == true) {
                control.value = "true";
		if (checkEscapeFalse) {
			checkEscapeFalse.checked = true;
			checkEscapeFalse.value = "true";
		}
        } else {
                control.value = "false";
		if (checkEscapeTrue) {
			checkEscapeTrue.checked = false;
			checkEscapeTrue.value = "false";
		}
        }
   } else if (control.name == "escape") {
	checkNone = getFormElement(theForm, "z_acc_type", "none");
	checkMobile = getFormElement(theForm, "mobile", "false");
	if (checkNone.checked == true) {
                control.checked = false;
                control.value = "false";
                return;
        }
	if (control.checked == true) {
		control.value = "true";
		if (checkMobile) {
			checkMobile.checked = true;
			checkMobile.value = "true";
		}
	} else {
		control.value = "false";
	}
   } else if (control.name == "kiosk") {
        checkNone = getFormElement(theForm, "acc_type", "none");
        if (checkNone.checked == true) {
                control.checked = false;
                control.value = "false";
                return;
        }
        if (control.checked == true) {
                control.value = "true";
        } else {
                control.value = "false";
        }
   } else if (control.name == "z_kiosk") {
        checkNone = getFormElement(theForm, "z_acc_type", "none");
        if (checkNone.checked == true) {
                control.checked = false;
                control.value = "false";
                return;
        }
	if (control.checked == true) {
                control.value = "true";
        } else {
                control.value = "false";
        }
   } else if (control.name == "sol_auth") {
        if (control.checked == true && theForm.self_reg.checked == true
		|| theForm.z_self_reg.checked == true) {
           control.value = "true";
        }
        else {
	   control.checked = false;
           control.value = "false";
        }
   }
}
function selectRadioButton(inForm, inName, inValue, inSelected) {
   for (count=0; count < inForm.elements.length; count++) {
       if (inForm.elements[count].name == inName &&
                 inForm.elements[count].value == inValue) {
             inForm.elements[count].checked = inSelected;
       }
   }
}
function getFormElement(inForm, inName, inValue) {
   for (i=0; i < inForm.elements.length; i++) {
       if (inForm.elements[i].name == inName &&
                 inForm.elements[i].value == inValue) {
             return inForm.elements[i];
       }
   }
   return;
}
function reflectPolicy(inForm, inPolicyString) {
   if (inPolicyString == "no_group") {
 	return;
   }
   card_allRB = getFormElement(inForm,"acc_type","all");
   card_regRB = getFormElement(inForm,"acc_type","reg");
   card_noneRB = getFormElement(inForm,"acc_type","none");
   pseudo_allRB = getFormElement(inForm,"z_acc_type","all");
   pseudo_regRB = getFormElement(inForm,"z_acc_type","reg");
   pseudo_noneRB = getFormElement(inForm,"z_acc_type","none");
   req_sol_auth = true;
   if (card_noneRB) {
   	card_noneRB.checked = true;
   }
   if (pseudo_noneRB) {
   	pseudo_noneRB.checked = true;
   }
   inForm.self_reg.checked = false;
   inForm.self_reg.value = "false";
   inForm.z_self_reg.checked = false;
   inForm.z_self_reg.value = "false";
   if (inForm.nscm_supported.value == "true") {
   	inForm.mobile.checked = false;
   	inForm.mobile.value = "false";
   	inForm.escape.checked = false;
   	inForm.escape.value = "false";
   }
   selectRadioButton(inForm, "multihead", "enable", false)
   selectRadioButton(inForm, "multihead", "disable", true)
   if (inForm.kiosk) {
   	inForm.kiosk.checked = false;
   	inForm.kiosk.value = "false";
   }
   if (inForm.z_kiosk) {
	inForm.z_kiosk.checked = false;
   	inForm.z_kiosk.value = "false";
   }
   mobile = false;
   escape = true;
   if (inPolicyString) {
   	stringArray = inPolicyString.split(' ');
   	if (stringArray) {
   	    for (i=0; i < stringArray.length; i++) {
   		switch (stringArray[i]) {
		    case '-M':
			mobile = true;
                        inForm.mobile.checked = true;
                        inForm.mobile.value = "true";
                        break;
		    case '-d':
			escape = false;
			break;
		    case '-k':
                        i++;
                        if (stringArray[i].indexOf("card") != -1) {
			    if (inForm.kiosk) {
				inForm.kiosk.checked = true;
                            	inForm.kiosk.value = "true";
			    }
                        } else if (stringArray[i].indexOf("pseudo") != -1) {
			    if (inForm.z_kiosk) {
                                inForm.z_kiosk.checked = true;
                                inForm.z_kiosk.value = "true";
			    }
                        } else {
			    if (inForm.kiosk) {
                            	inForm.kiosk.checked = true;
                            	inForm.kiosk.value = "true";
			    }
			    if (inForm.z_kiosk) {
                            	inForm.z_kiosk.checked = true;
                            	inForm.z_kiosk.value = "true";
			    }
                        }
                        break;
   		    case '-r':
   			i++;
   			if (stringArray[i].indexOf("card") != -1) {
   			    if (card_regRB) {
				card_noneRB.checked = false;
   				card_regRB.checked = true;
   			    }
   			} else if (stringArray[i].indexOf("pseudo") != -1) {
   			    if (pseudo_regRB) {
				pseudo_noneRB.checked = false;
   			    	pseudo_regRB.checked = true;
   			    }
   			} else {
   			    if (card_regRB && pseudo_regRB) {
				card_noneRB.checked = false;
   			    	card_regRB.checked = true;
				pseudo_noneRB.checked = false;
				pseudo_regRB.checked = true;
   			    }
   			}
   		   	break;
   		    case '-z':
   		    	i++;
   		    	if (stringArray[i].indexOf("card") != -1) {
   		    	    if (card_allRB) {
				card_noneRB.checked = false;
   		    	    	card_allRB.checked = true;
                                inForm.self_reg.checked = false;
				inForm.self_reg.value = "false";
				if (inForm.z_self_reg.checked == false) {
				    req_sol_auth = false;
   		    	    	}
			    }
   			} else if (stringArray[i].indexOf("pseudo") != -1) {
   			    if (pseudo_allRB) {
				pseudo_noneRB.checked = false;
   			    	pseudo_allRB.checked = true;
				inForm.z_self_reg.checked = false;
				inForm.z_self_reg.value= "false";
				if (inForm.self_reg.checked == false) {
                                    req_sol_auth = false;
                                }
   			    }
   			} else {
   			    if (card_allRB && pseudo_allRB) {
				card_noneRB.checked = false;
   			    	card_allRB.checked = true;
				pseudo_noneRB.checked = false;
				pseudo_allRB.checked = true;
				inForm.self_reg.checked = false;
				inForm.z_self_reg.checked = false;
	                        inForm.self_reg.value = "false";
                                inForm.z_self_reg.value = "false";
				req_sol_auth = false;
   			    }
   			}
   			break;
   		    case '-s':
   		        i++;
   		        if (stringArray[i].indexOf("card") != -1) {
   		            inForm.self_reg.checked = true;
   		            inForm.self_reg.value = "true";
   			} else if (stringArray[i].indexOf("pseudo") != -1) {
   		            inForm.z_self_reg.checked = true;
   		            inForm.z_self_reg.value = "true";
   			} else {
   		            inForm.self_reg.checked = true;
   		            inForm.z_self_reg.checked = true;
			    inForm.self_reg.value = "true";
                            inForm.z_self_reg.value = "true";
   			}
   			break;
   		    case '-p':
   		    	req_sol_auth = false;
   			break;
                    case '-m':
                        selectRadioButton(inForm, "multihead", "enable", true)
                        selectRadioButton(inForm, "multihead", "disable", false)
                        break;
   		    default:
   			break;
   		}
   	    }
	    if ( mobile == true && escape == true) {
		inForm.escape.checked = true;
		inForm.escape.value = "true";
	    }
   	    if ( req_sol_auth == true && (inForm.self_reg.checked == true ||
   			inForm.z_self_reg.checked == true) ) {
   		inForm.sol_auth.checked = true;
   		inForm.sol_auth.value = "true";
   	    } else {
   	    	inForm.sol_auth.checked = false;
   	    	inForm.sol_auth.value = "false";
   	    }
   	}
   }
}
// end of @(#)policy.js-src	1.21
