      *****************************************************************
      *                                                               *
      * Copyright (c) 2001 by Sun Microsystems, Inc.                  *
      * All rights reserved.                                          *
      *                                                               *
      *****************************************************************
       identification division.
       program-id. SSLSOCK0.

      *         This program is the first invoked by the SSL0
      *         transaction. This transaction must be submited
      *         by a message transmited over an SSL socket.
      *         The message format is:

      *         xxxx,12345678901234567890123456789012345

      *         where "xxxx" is the tran id SSL0 (1 to 4 characters)
      *         and "123456.........5" is up to 35 characters of 
      *         optional text.

      *         Information on the originating message and
      *         remote socket is provided in the DFHCOMMAREA.

      *         As its first action this program must send a
      *         message to the requesting socket. This lets the
      *         remote program know its request has been 
      *         accepted and the transaction started.

      *         The program will make four transmissions to
      *         the initating program in response to received
      *         messages and then close the socket.

      *         This program is provided to show method and
      *         has minimal checking and error messages.

      *         The Cobol compiler, unless instructed otherwise,
      *         will hold its working storage integer data items in
      *         machine idependent form. This matches the network
      *         ordering of information. Care should be exercised
      *         to ensure that this data ordering is correct when
      *         calling system library functions or passing data 
      *         structure containing such data to functions.

       environment division.
       data division.
       working-storage section.
      *
      * program buffers
      *
       77 ws-send-msg-size           pic s9(8) comp value 4096.
       77 ws-recv-msg-size           pic s9(8) comp value 4096.
       77 ws-recv-buf                pic x(4096).
       77 ws-send-buf                pic x(4096).
       77 ws-recv-total              pic s9(8) comp value 0.
       77 ws-recv-left               pic s9(8) comp value 0.
       77 ws-seq-num                 pic s9(8) comp value 0.
       77 ws-flags                   pic s9(8) comp value 0.
       01 ws-resp                    pic s9(8) comp.
      *
      * certificate information
      *
       01 ws-certificate-ptr         usage is pointer.
       01 ws-certificate-len         PIC 9(8) COMP.
       01 ws-commonname-ptr          usage is pointer.
       01 ws-commonname-len          PIC 9(8) COMP.
       01 ws-country-ptr             usage is pointer.
       01 ws-country-len             PIC 9(4) COMP.
       01 ws-state-ptr               usage is pointer.
       01 ws-state-len               PIC 9(4) COMP.
       01 ws-locality-ptr            usage is pointer.
       01 ws-locality-len            PIC 9(4) COMP.
       01 ws-organization-ptr        usage is pointer.
       01 ws-organization-len        PIC 9(4) COMP.
       01 ws-orgunit-ptr             usage is pointer.
       01 ws-orgunit-len             PIC 9(4) COMP.
       
       linkage section.
       01  DFHCOMMAREA.
         05 GIVE-TAKE-SOCKET         PIC 9(8) COMP.
         05 LSTN-NAME                PIC X(8).
         05 LSTN-SUBNAME             PIC X(8).
         05 CLIENT-IN-DATA           PIC X(36).
         05 SOCKADDR-IN-PARM.
           15 SIN-FAMILY             PIC 9(4) COMP.
           15 SIN-PORT               PIC 9(4) COMP.
           15 SIN-ADDRESS            PIC 9(8) COMP.
           15 SIN-ZERO               PIC X(8).
       01 ws-certificate             pic x(256).
       01 ws-commonname              pic x(256).
       01 ws-country                 pic x(256).
       01 ws-state                   pic x(256).
       01 ws-locality                pic x(256).
       01 ws-organization            pic x(256).
       01 ws-orgunit                 pic x(256).

       procedure division.
      *
      * when calling a C function the function returns its value
      * in the system variable return-code.
      *
       start-here.
      *
      * get client certificate information
      *
           exec cics extract certificate(ws-certificate-ptr)
                     owner
                     length(ws-certificate-len)
                     commonname(ws-commonname-ptr)
                     commonnamlen(ws-commonname-len)
                     country(ws-country-ptr)
                     countrylen(ws-country-len)
                     state(ws-state-ptr)
                     statelen(ws-state-len)
                     locality(ws-locality-ptr)
                     localitylen(ws-locality-len)
                     organization(ws-organization-ptr)
                     organizatlen(ws-organization-len)
                     orgunit(ws-orgunit-ptr)
                     orgunitlen(ws-orgunit-len)
                     resp(ws-resp)
           end-exec.

           if ws-resp NOT = DFHRESP(NORMAL)
               go to no-certificate.
      *
      * display certificate information
      *
           set address of ws-certificate to ws-certificate-ptr.
           set address of ws-commonname to ws-commonname-ptr.
           set address of ws-country to ws-country-ptr.
           set address of ws-state to ws-state-ptr.
           set address of ws-locality to ws-locality-ptr.
           set address of ws-organization to ws-organization-ptr.
           set address of ws-orgunit to ws-orgunit-ptr.

           if ws-certificate-len is less than 1 then
               display 'SSLSOCK0:Certificate not found'
           else
               display 'SSLSOCK0:Client certificate'.
               display 'SSLSOCK0:DN=',
                 ws-certificate(1:ws-certificate-len).

           if ws-commonname-len is greater than 0 then
               display 'SSLSOCK0:CN=',
                 ws-commonname(1:ws-commonname-len)
           end-if.

           if ws-country-len is greater than 0 then
               display 'SSLSOCK0:C=',
                 ws-country(1:ws-country-len)
           end-if.

           if ws-state-len is greater than 0 then
               display 'SSLSOCK0:ST=',
                 ws-state(1:ws-state-len)
           end-if.

           if ws-locality-len is greater than 0 then
               display 'SSLSOCK0:L=',
                 ws-locality(1:ws-locality-len)
           end-if.

           if ws-organization-len is greater than 0 then
               display 'SSLSOCK0:O=',
                 ws-organization(1:ws-organization-len)
           end-if.

           if ws-orgunit-len is greater than 0 then
               display 'SSLSOCK0:OU=',
                 ws-orgunit(1:ws-orgunit-len)
           end-if.
      *
      * get issuer certificate information
      *
           exec cics extract certificate(ws-certificate-ptr)
                     issuer
                     length(ws-certificate-len)
                     commonname(ws-commonname-ptr)
                     commonnamlen(ws-commonname-len)
                     country(ws-country-ptr)
                     countrylen(ws-country-len)
                     state(ws-state-ptr)
                     statelen(ws-state-len)
                     locality(ws-locality-ptr)
                     localitylen(ws-locality-len)
                     organization(ws-organization-ptr)
                     organizatlen(ws-organization-len)
                     orgunit(ws-orgunit-ptr)
                     orgunitlen(ws-orgunit-len)
                     resp(ws-resp)
           end-exec.

           if ws-resp NOT = DFHRESP(NORMAL)
               go to no-certificate.
      *
      * display certificate information
      *
           set address of ws-certificate to ws-certificate-ptr.
           set address of ws-commonname to ws-commonname-ptr.
           set address of ws-country to ws-country-ptr.
           set address of ws-state to ws-state-ptr.
           set address of ws-locality to ws-locality-ptr.
           set address of ws-organization to ws-organization-ptr.
           set address of ws-orgunit to ws-orgunit-ptr.

           if ws-certificate-len is less than 1 then
               display 'SSLSOCK0:Certificate not found'
           else
               display 'SSLSOCK0:Issuer certificate'.
               display 'SSLSOCK0:DN=',
                 ws-certificate(1:ws-certificate-len).

           if ws-commonname-len is greater than 0 then
               display 'SSLSOCK0:CN=',
                 ws-commonname(1:ws-commonname-len)
           end-if.

           if ws-country-len is greater than 0 then
               display 'SSLSOCK0:C=',
                 ws-country(1:ws-country-len)
           end-if.

           if ws-state-len is greater than 0 then
               display 'SSLSOCK0:ST=',
                 ws-state(1:ws-state-len)
           end-if.

           if ws-locality-len is greater than 0 then
               display 'SSLSOCK0:L=',
                 ws-locality(1:ws-locality-len)
           end-if.

           if ws-organization-len is greater than 0 then
               display 'SSLSOCK0:O=',
                 ws-organization(1:ws-organization-len)
           end-if.

           if ws-orgunit-len is greater than 0 then
               display 'SSLSOCK0:OU=',
                 ws-orgunit(1:ws-orgunit-len)
           end-if.

       no-certificate.
      *
      * data with transaction
      *
           display 'SSLSOCK0:transaction data =', CLIENT-IN-DATA.
           display 'SSLSOCK0:socket number    =', GIVE-TAKE-SOCKET.

       loop-1.
      *
      * set up the send buffer
      *
           add 1 to ws-seq-num. 
           evaluate ws-seq-num
           when 1 move all '1' to ws-send-buf 
           when 2 move all '2' to ws-send-buf 
           when 3 move all '3' to ws-send-buf 
           when 4 move all '4' to ws-send-buf 
           when 5 move all '5' to ws-send-buf
           when other move "data error" to ws-send-buf
           end-evaluate.
      *
      * send data
      *
           display 'SSLSOCK0:sequence number  =', ws-seq-num.
           display 'SSLSOCK0:send buffer      =', ws-send-buf(1:50).

           call "send" using by value GIVE-TAKE-SOCKET,
               by reference ws-send-buf,
               by value ws-send-msg-size,
               by value ws-flags.

           if return-code <= zero
               display 'SSLSOCK0:send error ',
               go to socket-error.
      *
      * set up the receive buffer
      *
           move low-values to ws-recv-buf.
           set ws-recv-total to zero.
           compute ws-recv-left = ws-recv-msg-size.
      *
      * receive data
      *
       recv-1.
           call "recv" using by value GIVE-TAKE-SOCKET,
               by reference ws-recv-buf(1+ws-recv-total:ws-recv-left),
               by value ws-recv-left,
               by value ws-flags.
      *
      * test what was received and decide what we should do
      *
           if return-code < zero
              display 'SSLSOCK0:recv error ',
              go to socket-error.

           if return-code = zero
              display 'SSLSOCK0:client disconnected',
              go to socket-error.
      *
      * have we received all the data yet?
      *
           compute ws-recv-total = ws-recv-total + return-code.
           compute ws-recv-left = ws-recv-msg-size - ws-recv-total.
      *
      * not yet
      *
           if ws-recv-left > 0 go to recv-1.
      *
      * received all the data
      *
           display 'SSLSOCK0:receive buffer   =', ws-recv-buf(1:50).
      *
      * make sure what we received was what we sent
      *
           if ws-recv-buf <> ws-send-buf
               display "SSLSOCK0:data doesn't match",
               go to socket-error.
      *
      * end of pass
      *
       loop-end.
           if ws-seq-num = 5 go to socket-error.
           go to loop-1.
      *
      * program end
      *
       socket-error.
           if ws-seq-num <> 5
               display "SSLSOCK0:did not complete".
      *
      * flush the send buffer and deallocate
      *
           display 'SSLSOCK0:closing socket'.
           call "close" using by value GIVE-TAKE-SOCKET .
      *
      * finised return to cics
      *
       socket-fin.
           display 'SSLSOCK0:done'.
           exec cics return end-exec.
           goback.
