/*
 *  ACCT03  is  the  first  program invoked by transactions AC03,
 *  ACLG, and AC05.  AC03 completes a request for printing  of  a
 *  customer record, which was processed initially by transaction
 *  AC01.  ACLG, which is a user request to print the log, merely
 *  requests  that AC05 be started when the log printer (L86O) is
 *  available.  AC05 transfers the log data from temporary storage
 *  to the printer.
 *
 */

ACCT03: PROCEDURE OPTIONS(MAIN);

    DCL 1 COMMAREA_FOR_ACCT04,
          2 ERR_PGM     CHAR(8)       INIT('ACCT03'),
          2 ERR_FN      CHAR,
          2 ERR_RCODE   CHAR,
        1 TS_LNG        FIXED BIN(15) INIT(+751);

%INCLUDE 'ACCTSET.inc';

    DCL ACCTMSGO_STRING CHAR(STORAGE(ACCTMSGO)) DEFINED(ACCTMSGO);

INIT:

    EXEC CICS HANDLE CONDITION
              ITEMERR(LOG_END)
              QIDERR(RTRN)
              ERROR(NO_GOOD);

    /* TEST FOR TRANSACTION TYPE.  */

    IF EIBTRNID = 'AC03' THEN GOTO AC03;
    IF EIBTRNID = 'ACLG' THEN GOTO ACLG;
    GOTO AC05;

AC03: /* PROCESS TRANSACTION 'AC03'. */

    EXEC CICS RETRIEVE
              INTO(ACCTDTLI)
              LENGTH(TS_LNG);

    EXEC CICS SEND
              MAP('ACCTDTL')
              MAPSET('ACCTSET')
              PRINT
              L80
              ERASE;
    GOTO RTRN;

ACLG: /* PROCESS TRANSACTION 'ACLG'.  */

    EXEC CICS START
              TRANSID('AC05')
              TERMID('CPRT');

    ACCTMSGO_STRING = LOW(STORAGE(ACCTMSGO));
    MSGO = 'PRINTING OF LOG HAS BEEN SCHEDULED';
    EXEC CICS SEND
              MAP('ACCTMSG')
              MAPSET('ACCTSET')
              ERASE
              FREEKB;
    GOTO RTRN;

AC05: /* PROCESS TRANSACTION 'AC05'.  */

    EXEC CICS READQ TS
              QUEUE('ACCTLOG')
              INTO(ACCTDTLI)
              LENGTH(TS_LNG)
              NEXT;

    EXEC CICS SEND
              MAP('ACCTDTL')
              MAPSET('ACCTSET')
              PRINT
              ERASE;

    GOTO AC05;

LOG_END:

    EXEC CICS DELETEQ TS QUEUE('ACCTLOG');

RTRN:

    EXEC CICS RETURN;

NO_GOOD: /* PROCESS UNRECOVERABLE ERRORS.  */

    ERR_FN = EIBFN;
    ERR_RCODE = EIBRCODE;
    EXEC CICS HANDLE CONDITION ERROR;
    EXEC CICS LINK
              PROGRAM('ACCT04')
              COMMAREA(COMMAREA_FOR_ACCT04)
              LENGTH(10);

END ACCT03;
