/* 
 *  ACCT02  is the first program invoked by the AC02 transaction.
 *  It completes requests for account file updates (adds, modifies,
 *  and  deletes), after the user entered the update information.
 *
 */

ACCT02: PROCEDURE OPTIONS(MAIN);

%INCLUDE 'ALPHANUM.dcl';
%REPLACE SPACE BY ' ';

    DCL 1 MISC,
          2 MENU_MSGNO          FIXED BIN(15) INIT(+1),
          2 DTL_MSGNO           FIXED BIN(15) INIT(+0),
          2 ACCT_LNG            FIXED BIN(15) INIT(+383),
          2 ACIX_LNG            FIXED BIN(15) INIT(+63),
          2 DTL_LNG             FIXED BIN(15) INIT(+751),
          2 DUMMY_U             UNION,
            4 DUMMY             FIXED BIN(15) INIT(+128),
            4 FILLER1,
              6 FILLER          CHAR,
              6 HEX80           CHAR,
          2 STARS               CHAR(12)      INIT('************'),
          2 USE_QID_U           UNION,
            4 USE_QID_CHAR      CHAR(8),
            4 USE_QID_S,
              6 USE_QID1        CHAR(3)       INIT('AC0'),
              6 USE_QID2        CHAR(5),
          2 USE_REC,
            4 USE_TERM          CHAR(4)       INIT(SPACE),
            4 USE_TIME          FIXED DEC(7,0),
            4 USE_DATE          FIXED DEC(7,0),
          2 USE_LNG             FIXED BIN(15) INIT(+12),
          2 OLD_IXKEY,
            4 IXOLD_SNAME       CHAR(12),
            4 IXOLD_ACCT        CHAR(5),
          2 COMMAREA_FOR_ACCT04,
            4 ERR_PGRMID        CHAR(18)      INIT('ACCT02'),
            4 ERR_FN            CHAR,
            4 ERR_RCODE         CHAR,
          2 PAY_INIT,
              /* this structure match acctrec.pay_hist (see acctrec.inc) */
            4 BAL               CHAR(8)       INIT('    0.00'),
            4 BMO               PIC '99'      INIT('00'),
            4 BDAY              PIC '99'      INIT('00'),
            4 BYR               PIC '99'      INIT('00'),
            4 BAMT              CHAR(8)       INIT('    0.00'),
            4 PMO               PIC '99'      INIT('00'),
            4 PDAY              PIC '99'      INIT('00'),
            4 PYR               PIC '99'      INIT('00'),
            4 PAMT              CHAR(8)       INIT('    0.00'),
          2 MENU_MSG_U          UNION,
              /* MESSAGES DISPLAYED ON MENU SCREEN  */
            4 MENU_MSG(4)       CHAR(60),
            4 MENU_MSG_LIST,
              6 FILLER1         CHAR(60)      INIT('PREVIOUS REQUEST CANCELLED AS REQUESTED'),
              6 FILLER2         CHAR(60)      INIT('REQUESTED ADDITION COMPLETED'),
              6 FILLER3         CHAR(60)      INIT('REQUESTED MODIFICATION COMPLETED'),
              6 FILLER4         CHAR(60)      INIT('REQUESTED DELETION COMPLETED'),
          2 DTL_MSG_U           UNION,
              /* MESSAGES DISPLAYED ON DETAIL SCREEN  */
            4 DTL_MSG(5)        CHAR(60),
            4 DTL_MSG_LIST,
              6 FILLER1         CHAR(60)      INIT('EITHER ENTER "Y" TO CONFIRM OR "CLEAR" TO CANCEL'),
              6 FILLER2         CHAR(60)      INIT('YOUR REQUEST WAS INTERRUPTED; PLEASE CANCEL AND RETRY'),
              6 FILLER3         CHAR(60)      INIT('CORRECT HIGHLIGHTED ITEMS (STARS MEAN ITEM REQUIRED)'),
              6 FILLER4         CHAR(60)      INIT('USE ONLY "ENTER" (TO PROCEED) OR "CLEAR" (TO CANCEL)'),
              6 FILLER5         CHAR(60)      INIT('MAKE SOME ENTRIES AND "ENTER" OR "CLEAR" TO CANCEL'),
          2 MOD_LINE_U          UNION,
            4 MOD_LINE_CHAR     CHAR(59),
            4 MOD_LINE_S,
              6 FILLER          CHAR(25)      INIT('==========> CHANGES TO:  '),
              6 MOD_NAME        CHAR(6)       INIT(SPACE),
              6 MOD_TELE        CHAR(5)       INIT(SPACE),
              6 MOD_ADDR        CHAR(6)       INIT(SPACE),
              6 MOD_AUTH        CHAR(6)       INIT(SPACE),
              6 MOD_CARD        CHAR(6)       INIT(SPACE),
              6 MOD_CODE        CHAR(5)       INIT(SPACE),
          2 UPDT_LINE_U         UNION,
            4 UPDT_LINE_C       CHAR(60),
            4 UPDT_LINE_S,
              6 FILLER1         CHAR(30)      INIT('==========> UPDATED AT TERM:  '),
              6 UPDT_TERM       CHAR(4),
              6 FILLER2         CHAR(6)       INIT('  AT  '),
              6 UPDT_TIME       PIC '(7)9',
              6 FILLER3         CHAR(6)       INIT('  ON  '),
              6 UPDT_DATE       PIC '(7)9';

    DCL 1 NEW_ACCTREC,
    %INCLUDE 'ACCTREC.inc';

    DCL 1 OLD_ACCTREC,
    %INCLUDE 'ACCTREC.inc';

    DCL 1 NEW_ACIXREC,
    %INCLUDE 'ACIXREC.inc';

    DCL 1 OLD_ACIXREC,
    %INCLUDE  'ACIXREC.inc';

    %INCLUDE 'ACCTSET.inc';
    %INCLUDE 'dfhaid.inc';
    %INCLUDE 'dfhbmsca.inc';

    DCL ACCTDTLI_STRING CHAR(STORAGE(ACCTDTLI)) DEFINED(ACCTDTLI);
    DCL ACCTDTLO_STRING CHAR(STORAGE(ACCTDTLO)) DEFINED(ACCTDTLO);
    DCL ACCTMNUO_STRING CHAR(STORAGE(ACCTMNUO)) DEFINED(ACCTMNUO);

    DCL 1 COMMAREA      BASED(DFHCOMMAREA),
          2 REQC        CHAR,
          2 ACCTC       CHAR(5);

    ACCTDTLI_STRING = LOW(STORAGE(ACCTDTLI));
    OLD_ACCTREC = '';
    NEW_ACCTREC = '';
    OLD_ACIXREC = '';
    NEW_ACIXREC = '';

    EXEC CICS HANDLE AID
              CLEAR(CK_OWN)
              PA1(PA_KEY)
              PA2(PA_KEY)
              PA3(PA_KEY);

    EXEC CICS HANDLE CONDITION
              QIDERR(NO_OWN)
              MAPFAIL(NO_MAP)
              ERROR(NO_GOOD);

    /* GET INPUT AND BUILD NEW RECORD.  */

    EXEC CICS RECEIVE
              MAP('ACCTDTL')
              MAPSET('ACCTSET');

    IF REQC ~= 'A' THEN
        DO;
        EXEC CICS READ
                  DATASET('ACCTFIL')
                  INTO(OLD_ACCTREC)
                  RIDFLD(ACCTC)
                  UPDATE
                  LENGTH(ACCT_LNG);
        NEW_ACCTREC = OLD_ACCTREC;
        IXOLD_SNAME = OLD_ACCTREC.SNAMEDO;
        IXOLD_ACCT = ACCTC;
        END;

    IF REQC = 'X' THEN
        IF VFYDI = 'Y' THEN
            GOTO CK_OWN;
        ELSE
            DO;
            VFYDL = -1;
            VFYDA =  DFHUNIMD;
            DTL_MSGNO = 1;
            GOTO INPUT_REDISPLAY;
            END;

    IF SNAMEDL  > 0 THEN NEW_ACCTREC.SNAMEDO  = SNAMEDI;
    IF FNAMEDL  > 0 THEN NEW_ACCTREC.FNAMEDO  = FNAMEDI;
    IF MIDL     > 0 THEN NEW_ACCTREC.MIDO     = MIDI;
    IF TTLDL    > 0 THEN NEW_ACCTREC.TTLDO    = TTLDI;
    IF TELDL    > 0 THEN NEW_ACCTREC.TELDO    = TELDI;
    IF ADDR1DL  > 0 THEN NEW_ACCTREC.ADDR1DO  = ADDR1DI;
    IF ADDR2DL  > 0 THEN NEW_ACCTREC.ADDR2DO  = ADDR2DI;
    IF ADDR3DL  > 0 THEN NEW_ACCTREC.ADDR3DO  = ADDR3DI;
    IF AUTH1DL  > 0 THEN NEW_ACCTREC.AUTH1DO  = AUTH1DI;
    IF AUTH2DL  > 0 THEN NEW_ACCTREC.AUTH2DO  = AUTH2DI;
    IF AUTH3DL  > 0 THEN NEW_ACCTREC.AUTH3DO  = AUTH3DI;
    IF AUTH4DL  > 0 THEN NEW_ACCTREC.AUTH4DO  = AUTH4DI;
    IF CARDSDL  > 0 THEN NEW_ACCTREC.CARDSDO  = CARDSDI;
    IF IMODL    > 0 THEN NEW_ACCTREC.IMODO    = IMODI;
    IF IDAYDL   > 0 THEN NEW_ACCTREC.IDAYDO   = IDAYDI;
    IF IYRDL    > 0 THEN NEW_ACCTREC.IYRDO    = IYRDI;
    IF RSNDL    > 0 THEN NEW_ACCTREC.RSNDO    = RSNDI;
    IF CCODEDL  > 0 THEN NEW_ACCTREC.CCODEDO  = CCODEDI;
    IF APPRDL   > 0 THEN NEW_ACCTREC.APPRDO   = APPRDI;
    IF SCODE1DL > 0 THEN NEW_ACCTREC.SCODE1DO = SCODE1DI;
    IF SCODE2DL > 0 THEN NEW_ACCTREC.SCODE2DO = SCODE2DI;
    IF SCODE3DL > 0 THEN NEW_ACCTREC.SCODE3DO = SCODE3DI;

    IF REQC = 'A' THEN
        GOTO EDIT_0;

    IF SNAMEDF  = HEX80 THEN NEW_ACCTREC.SNAMEDO  = SPACE;
    IF FNAMEDF  = HEX80 THEN NEW_ACCTREC.FNAMEDO  = SPACE;
    IF MIDF     = HEX80 THEN NEW_ACCTREC.MIDO     = SPACE;
    IF TTLDF    = HEX80 THEN NEW_ACCTREC.TTLDO    = SPACE;
    IF TELDF    = HEX80 THEN NEW_ACCTREC.TELDO    = SPACE;
    IF ADDR1DF  = HEX80 THEN NEW_ACCTREC.ADDR1DO  = SPACE;
    IF ADDR2DF  = HEX80 THEN NEW_ACCTREC.ADDR2DO  = SPACE;
    IF ADDR3DF  = HEX80 THEN NEW_ACCTREC.ADDR3DO  = SPACE;
    IF AUTH1DF  = HEX80 THEN NEW_ACCTREC.AUTH1DO  = SPACE;
    IF AUTH2DF  = HEX80 THEN NEW_ACCTREC.AUTH2DO  = SPACE;
    IF AUTH3DF  = HEX80 THEN NEW_ACCTREC.AUTH3DO  = SPACE;
    IF AUTH4DF  = HEX80 THEN NEW_ACCTREC.AUTH4DO  = SPACE;
    IF CARDSDF  = HEX80 THEN NEW_ACCTREC.CARDSDO  = SPACE;
    IF IMODF    = HEX80 THEN NEW_ACCTREC.IMODO    = SPACE;
    IF IDAYDF   = HEX80 THEN NEW_ACCTREC.IDAYDO   = SPACE;
    IF IYRDF    = HEX80 THEN NEW_ACCTREC.IYRDO    = SPACE;
    IF RSNDF    = HEX80 THEN NEW_ACCTREC.RSNDO    = SPACE;
    IF CCODEDF  = HEX80 THEN NEW_ACCTREC.CCODEDO  = SPACE;
    IF APPRDF   = HEX80 THEN NEW_ACCTREC.APPRDO   = SPACE;
    IF SCODE1DF = HEX80 THEN NEW_ACCTREC.SCODE1DO = SPACE;
    IF SCODE2DF = HEX80 THEN NEW_ACCTREC.SCODE2DO = SPACE;
    IF SCODE3DF = HEX80 THEN NEW_ACCTREC.SCODE3DO = SPACE;

    IF STRING(OLD_ACCTREC) = STRING(NEW_ACCTREC) THEN
        DO;
        DTL_MSGNO = 5;
        GOTO INPUT_REDISPLAY;
        END;

EDIT_0: /*   EDIT INPUT.  */

    ACCTDTLI_STRING = LOW(STORAGE(ACCTDTLI));
    IF NEW_ACCTREC.SNAMEDO = SPACE THEN
        SNAMEDI = STARS;
    ELSE IF ALPHABETIC(NEW_ACCTREC.SNAMEDO) THEN
        GOTO EDIT_1;

    SNAMEDA = DFHUNIMD;
    SNAMEDL = -1;

EDIT_1:

    IF NEW_ACCTREC.FNAMEDO = SPACE THEN
        FNAMEDI = STARS;
    ELSE IF ALPHABETIC(NEW_ACCTREC.FNAMEDO) THEN
        GOTO EDIT_2;

    FNAMEDA = DFHUNIMD;
    FNAMEDL = -1;

EDIT_2:

    IF ~ALPHABETIC(NEW_ACCTREC.MIDO) THEN
        DO;
        MIDA = DFHUNIMD;
        MIDL = -1;
        END;

    IF ~ALPHABETIC(NEW_ACCTREC.TTLDO) THEN
        DO;
        TTLDA = DFHUNIMD;
        TTLDL = -1;
        END;

    IF (NEW_ACCTREC.TELDO ~= SPACE & ~NUMERIC(NEW_ACCTREC.TELDO)) THEN
        DO;
        TELDA = DFHUNIMD;
        TELDL = -1;
        END;

    IF NEW_ACCTREC.ADDR1DO = SPACE THEN
        DO;
        ADDR1DI = STARS;
        ADDR1DA = DFHBMBRY;
        ADDR1DL = -1;
        END;

    IF NEW_ACCTREC.ADDR2DO = SPACE THEN
        DO;
        ADDR2DI = STARS;
        ADDR2DA = DFHBMBRY;
        ADDR2DL = -1;
        END;

    IF NEW_ACCTREC.CARDSDO = SPACE THEN
        CARDSDI = STARS;
    ELSE
    IF NEW_ACCTREC.CARDSDO > '0'
     & NEW_ACCTREC.CARDSDO <= '9' THEN
        GOTO EDIT_3;

    CARDSDA = DFHUNIMD;
    CARDSDL = -1;

EDIT_3:

    IF NEW_ACCTREC.IMODO = SPACE THEN
        IMODI = STARS;
    ELSE
    IF NUMERIC(NEW_ACCTREC.IMODO)
     & NEW_ACCTREC.IMODO > '00'
     & NEW_ACCTREC.IMODO < '13' THEN
        GOTO EDIT_4;

    IMODA = DFHUNIMD;
    IMODL = -1;

EDIT_4:

    IF NEW_ACCTREC.IDAYDO = SPACE THEN
        IDAYDI = STARS;
    ELSE
    IF NUMERIC(NEW_ACCTREC.IDAYDO)
     & NEW_ACCTREC.IDAYDO > '00'
     & NEW_ACCTREC.IDAYDO < '32' THEN
        GOTO EDIT_5;

    IDAYDA = DFHUNIMD;
    IDAYDL = -1;

EDIT_5:

    IF NEW_ACCTREC.IYRDO = SPACE THEN
        IYRDI = STARS;
    ELSE
    IF NUMERIC(NEW_ACCTREC.IYRDO)
     THEN
        GOTO EDIT_6;

    IYRDA = DFHUNIMD;
    IYRDL = -1;

EDIT_6:

    IF NEW_ACCTREC.RSNDO = SPACE THEN
        RSNDI = STARS;
    ELSE
    IF NEW_ACCTREC.RSNDO = 'N'
     | NEW_ACCTREC.RSNDO = 'L'
     | NEW_ACCTREC.RSNDO = 'S'
     | NEW_ACCTREC.RSNDO = 'R' THEN
        GOTO EDIT_7;

    RSNDA = DFHUNIMD;
    RSNDL = -1;

EDIT_7:

    IF NEW_ACCTREC.CCODEDO = SPACE THEN
        DO;
        CCODEDI = STARS;
        CCODEDL = -1;
        CCODEDA = DFHBMBRY;
        END;

    IF NEW_ACCTREC.APPRDO = SPACE THEN
        DO;
        APPRDI = STARS;
        APPRDL = -1;
        APPRDA = DFHBMBRY;
        END;

    IF ACCTDTLI_STRING ~= LOW(STORAGE(ACCTDTLI)) THEN
        DO;
        DTL_MSGNO = 3;
        GOTO INPUT_REDISPLAY;
        END;

    IF REQC = 'A' THEN
        DO;
        NEW_ACCTREC.ACCTDO = ACCTC;
        NEW_ACCTREC.STATDO = 'N';
        NEW_ACCTREC.LIMITDO = ' 1000.00';
        NEW_ACCTREC(1).PAY_HIST = PAY_INIT;
        NEW_ACCTREC(2).PAY_HIST = PAY_INIT;
        NEW_ACCTREC(3).PAY_HIST = PAY_INIT;
        END;

    NEW_ACIXREC = NEW_ACCTREC, BY NAME;

CK_OWN: /*  CHECK OWNERSHIP OF ACCOUNT NUMBER  */

    USE_QID2 = ACCTC;

    EXEC CICS HANDLE CONDITION
              LENGERR(NO_OWN);

    EXEC CICS READQ TS
              QUEUE(USE_QID_CHAR)
              INTO(USE_REC)
              LENGTH(USE_LNG)
              ITEM(1);

    EXEC CICS HANDLE CONDITION
              LENGERR(NO_GOOD);

    IF USE_TERM ~= EIBTRMID | USE_LNG ~= 12 THEN
        GOTO NO_OWN;

    IF EIBAID = DFHCLEAR | MENU_MSGNO = 5 THEN
        GOTO RELEASE_ACCT;

    /*  WRITE HARDCOPY LOG RECORDS.  */
    ACCTDTLO_STRING = LOW(STORAGE(ACCTDTLO));
    HISTTLDA = DFHBMDAR;
    STATTLDA = DFHBMDAR;
    STATDA   = DFHBMDAR;
    LIMTTLDA = DFHBMDAR;
    LIMITDA  = DFHBMDAR;

    IF REQC = 'A' THEN
        DO;
        TITLEDO = 'NEW RECORD';
        GOTO LOG_1;
        END;

    ACCTDTLO = OLD_ACCTREC, BY NAME;

    IF REQC = 'X' THEN
        DO;
        TITLEDO =  'DELETION';
        GOTO LOG_2;
        END;

    TITLEDO = 'BEFORE CHANGE';
    IF OLD_ACCTREC.SNAMEDO ~= NEW_ACCTREC.SNAMEDO
     | OLD_ACCTREC.FNAMEDO ~= NEW_ACCTREC.FNAMEDO
     | OLD_ACCTREC.MIDO    ~= NEW_ACCTREC.MIDO
     | OLD_ACCTREC.TTLDO   ~= NEW_ACCTREC.TTLDO THEN
        MOD_NAME = 'NAME';

    IF OLD_ACCTREC.TELDO ~= NEW_ACCTREC.TELDO THEN
        MOD_TELE = 'TEL';

    IF OLD_ACCTREC.ADDR1DO ~= NEW_ACCTREC.ADDR1DO
     | OLD_ACCTREC.ADDR2DO ~= NEW_ACCTREC.ADDR2DO
     | OLD_ACCTREC.ADDR3DO ~= NEW_ACCTREC.ADDR3DO THEN
        MOD_ADDR = 'ADDR';

    IF OLD_ACCTREC.AUTH1DO ~= NEW_ACCTREC.AUTH1DO
     | OLD_ACCTREC.AUTH2DO ~= NEW_ACCTREC.AUTH2DO
     | OLD_ACCTREC.AUTH3DO ~= NEW_ACCTREC.AUTH3DO
     | OLD_ACCTREC.AUTH4DO ~= NEW_ACCTREC.AUTH4DO THEN
        MOD_AUTH = 'AUTH';

    IF OLD_ACCTREC.CARDSDO ~= NEW_ACCTREC.CARDSDO
     | OLD_ACCTREC.IMODO   ~= NEW_ACCTREC.IMODO
     | OLD_ACCTREC.IDAYDO  ~= NEW_ACCTREC.IDAYDO
     | OLD_ACCTREC.IYRDO   ~= NEW_ACCTREC.IYRDO
     | OLD_ACCTREC.RSNDO   ~= NEW_ACCTREC.RSNDO
     | OLD_ACCTREC.CCODEDO ~= NEW_ACCTREC.CCODEDO
     | OLD_ACCTREC.APPRDO  ~= NEW_ACCTREC.APPRDO THEN
        MOD_CARD = 'CARD';

    IF OLD_ACCTREC. SCODE1DO ~= NEW_ACCTREC. SCODE1DO
     | OLD_ACCTREC. SCODE2DO ~= NEW_ACCTREC. SCODE2DO
     | OLD_ACCTREC. SCODE3DO ~= NEW_ACCTREC. SCODE3DO THEN
        MOD_CODE = 'CODES';
        MSGDO = MOD_LINE_CHAR;
        EXEC CICS WRITEQ TS
                  QUEUE('ACCTLOG')
                  FROM(ACCTDTLO)
                  LENGTH(DTL_LNG);
        TITLEDO = 'AFTER CHANGE';

LOG_1:

    ACCTDTLO = NEW_ACCTREC, BY NAME;

LOG_2:

    UPDT_TERM = EIBTRMID;
    UPDT_TIME = EIBTIME;
    UPDT_DATE = EIBDATE;
    MSGDO = UPDT_LINE_C;
    EXEC CICS WRITEQ TS
              QUEUE('ACCTLOG')
              FROM(ACCTDTLO)
              LENGTH(DTL_LNG);

    /*  UPDATE THE FILES FOR ADD REQUESTS.  */
    IF REQC = 'X' THEN
        GOTO UPDT_DELETE;
    IF REQC = 'M' THEN
        GOTO UPDT_MODIFY;

UPDT_ADD:

    MENU_MSGNO = 2;
    EXEC CICS WRITE
              DATASET('ACCTFIL')
              FROM(NEW_ACCTREC)
              RIDFLD(ACCTC)
              LENGTH(ACCT_LNG);

    EXEC CICS WRITE
              DATASET('ACCTIX')
              FROM(NEW_ACIXREC)
              RIDFLD(NEW_ACIXREC.SNAMEDO)
              LENGTH(ACIX_LNG);

    GOTO RELEASE_ACCT;

UPDT_MODIFY: /*  UPDATE THE FILES FOR MODIFY REQUESTS.  */

    MENU_MSGNO = 3;
    EXEC CICS REWRITE DATASET('ACCTFIL') FROM(NEW_ACCTREC) LENGTH(ACCT_LNG);
    IF NEW_ACCTREC.SNAMEDO ~= OLD_ACCTREC.SNAMEDO THEN
        DO;
        EXEC CICS DELETE
                  DATASET('ACCTIX')
                  RIDFLD(OLD_IXKEY);
        EXEC CICS WRITE
                  DATASET('ACCTIX')
                  FROM(NEW_ACIXREC)
                  RIDFLD(NEW_ACIXREC.SNAMEDO)
                  LENGTH(ACIX_LNG);
        END;
    ELSE
    IF NEW_ACCTREC.FNAMEDO ~= OLD_ACCTREC.FNAMEDO
     | NEW_ACCTREC.MIDO    ~= OLD_ACCTREC.MIDO
     | NEW_ACCTREC.TTLDO   ~= OLD_ACCTREC.TTLDO
     | NEW_ACCTREC.ADDR1DO ~= OLD_ACCTREC.ADDR1DO THEN
        DO;
        EXEC CICS READ
                  DATASET('ACCTIX')
                  INTO(OLD_ACIXREC)
                  RIDFLD(OLD_IXKEY)
                  LENGTH(ACIX_LNG)
                  UPDATE;
        EXEC CICS REWRITE
                  DATASET('ACCTIX')
                  FROM(NEW_ACIXREC)
                  LENGTH(ACIX_LNG);
        END;

    GOTO RELEASE_ACCT;

UPDT_DELETE: /*  UPDATE THE FILES FOR DELETE REQUESTS.  */

    MENU_MSGNO = 4;
    EXEC CICS DELETE
              DATASET('ACCTFIL');
    EXEC CICS DELETE
              DATASET('ACCTIX')
              RIDFLD(OLD_IXKEY);

RELEASE_ACCT: /*  RELEASE OWNERSHIP OF ACCOUNT NUMBER.  */

    EXEC CICS DELETEQ TS
              QUEUE(USE_QID_CHAR);

MENU_REFRESH: /*  SEND MENU MAP BACK TO TERMINAL.  */

    ACCTMNUO_STRING = LOW(STORAGE(ACCTMNUO));
    MSGMO = MENU_MSG(MENU_MSGNO);

    EXEC CICS SEND
              MAP('ACCTMNU')
              MAPSET('ACCTSET')
              ERASE
              FREEKB;

    EXEC CICS RETURN
              TRANSID('AC01');

INPUT_REDISPLAY: /*  FOR INPUT ERRORS, RESEND DETAIL MAP.  */

    MSGDO = DTL_MSG(DTL_MSGNO);
    IF DTL_MSGNO = 2
     | DTL_MSGNO = 4
     | DTL_MSGNO = 5 THEN 
        SNAMEDL = -1;

    EXEC CICS SEND
              MAP('ACCTDTL')
              MAPSET('ACCTSET')
              DATAONLY
              CURSOR
              FREEKB;

    EXEC CICS RETURN
              TRANSID('AC02')
              COMMAREA(COMMAREA)
              LENGTH(6);

NO_OWN: /* PROCESSING FOR RECOVERABLE ERRORS.  */

    IF EIBAID = DFHCLEAR | MENU_MSGNO = 5 THEN
        GOTO MENU_REFRESH;

    DTL_MSGNO = 2;
    GOTO INPUT_REDISPLAY;

NO_MAP:

    IF EIBAID = DFHENTER THEN
        DO;
        DTL_MSGNO = 5;
        GOTO INPUT_REDISPLAY;
        END;

    MENU_MSGNO = 5;
    GOTO CK_OWN;

PA_KEY:

    DTL_MSGNO = 4;
    GOTO INPUT_REDISPLAY;

NO_GOOD: /* PROCESSING FOR UNRECOVERABLE ERRORS.  */

    ERR_FN = EIBFN;
    ERR_RCODE = EIBRCODE;

    EXEC CICS HANDLE CONDITION ERROR;

    EXEC CICS LINK
              PROGRAM('ACCT04')
              COMMAREA(COMMAREA_FOR_ACCT04)
              LENGTH(10);

END ACCT02;
