/*
 *  ACCT01  is the first program invoked by the AC01 transaction.
 *  It analyzes  all  requests,  and  completes  those  for  name
 *  inquiries  and  record displays.  For update transactions, it
 *  sends the appropriate data entry screen  and  sets  the  next
 *  transaction  identifier  to  AC02, which completes the update
 *  operation.  For print requests, it starts transaction AC03 to
 *  do the actual printing.
 *
 */

ACCT01: PROCEDURE OPTIONS(MAIN);

%REPLACE SPACE BY ' ';

    DCL 1 MISC,
          2 MSG_NO              FIXED BIN(15)  INIT(+0),
          2 ACCT_LNG            FIXED BIN(15)  INIT(+383),
          2 ACIX_LNG            FIXED BIN(15)  INIT(+63),
          2 DTL_LNG             FIXED BIN(15)  INIT(+751),
          2 STARS               CHAR(12)       INIT('************'),
          2 USE_QID_U           UNION,
            4 USE_QID_CHAR      CHAR(8),
            4 USE_QID_S,
              6 USE_QID1        CHAR(3)        INIT('AC0'),
              6 USE_QID2        CHAR(5),
          2 USE_REC,
            4 USE_TERM          CHAR(4)        INIT(SPACE),
            4 USE_TIME          FIXED DEC(7,0),
            4 USE_DATE          FIXED DEC(7,0),
          2 USE_LIMIT           FIXED DEC(7,0) INIT(+1000),
          2 USE_ITEM            FIXED BIN(15)  INIT(+1),
          2 USE_LNG             FIXED BIN(15)  INIT(+12),
          2 IN_AREA,
            4 IN_TYPE           CHAR           INIT('R'),
            4 IN_REQ,
              6 REQC            CHAR           INIT(SPACE),
              6 ACCTC           CHAR(5)        INIT(SPACE),
              6 PRTRC           CHAR(4)        INIT(SPACE),
            4 IN_NAMES,
              6 SNAMEC          CHAR(18)       INIT(SPACE),
              6 FNAMEC          CHAR(12)       INIT(SPACE),
          2 COMMAREA_FOR_ACCT04,
            4 ERR_PGRMID        CHAR(18)       INIT('ACCT01'),
            4 ERR_FN            CHAR,
            4 ERR_RCODE         CHAR,
          2 LINE_CNT            FIXED BIN(15)  INIT(+0),
          2 MAX_LINES           FIXED BIN(15)  INIT(+6),
          2 IX                  FIXED BIN(15),
          2 SRCH_CTRL,
            4 FILLER1           CHAR           INIT('S'),
            4 BRKEY,
              6 BRKEY_SNAME     CHAR(12),
              6 BRKEY_ACCT      CHAR(5),
            4 MAX_SNAME         CHAR(12),
            4 MAX_FNAME         CHAR(7),
            4 MIN_FNAME         CHAR(7),
          2 SUM_LINE,
            4 ACCTDO            CHAR(5),
            4 FILLER2           CHAR(3)        INIT(SPACE),
            4 SNAMEDO           CHAR(12),
            4 FILLER3           CHAR(2)        INIT(SPACE),
            4 FNAMEDO           CHAR(7),
            4 FILLER4           CHAR(2)        INIT(SPACE),
            4 MIDO              CHAR(1),
            4 FILLER5           CHAR(2)        INIT(SPACE),
            4 TTLDO             CHAR(4),
            4 FILLER6           CHAR(2)        INIT(SPACE),
            4 ADDR1DO           CHAR(24),
            4 FILLER7           CHAR(2)        INIT(SPACE),
            4 STATDO            CHAR(2),
            4 FILLER8           CHAR(3)        INIT(SPACE),
            4 LIMITDO           CHAR(8),
          2 PAY_LINE,
            4 BAL               CHAR(8),
            4 FILLER9           CHAR(6)        INIT(SPACE),
            4 BMO               PIC '99',
            4 FILLER10          CHAR           INIT('/'),
            4 BDAY              PIC '99',
            4 FILLER11          CHAR           INIT('/'),
            4 BYR               PIC '99',
            4 FILLER12          CHAR(4)        INIT(SPACE),
            4 BAMT              CHAR(8),
            4 FILLER13          CHAR(7)        INIT(SPACE),
            4 PMO               PIC '99',
            4 FILLER14          CHAR           INIT('/'),
            4 PDAY              PIC '99',
            4 FILLER15          CHAR           INIT('/'),
            4 PYR               PIC '99',
            4 FILLER16          CHAR(4)        INIT(SPACE),
            4 PAMT              CHAR(8);
    
%INCLUDE 'dfhbmsca.inc';
%INCLUDE 'dfhaid.inc';
%INCLUDE 'ALPHANUM.dcl';

    DCL 1 ACCTREC,
    %INCLUDE 'ACCTREC.inc';

    DCL 1 ACIXREC,
    %INCLUDE 'ACIXREC.inc';
    %INCLUDE 'ACCTSET.inc';

    DCL ACCTMNUI_STRING         CHAR(STORAGE(ACCTMNUI)) DEFINED(ACCTMNUI);
    DCL ACCTDTLI_STRING         CHAR(STORAGE(ACCTDTLI)) DEFINED(ACCTDTLI);

    DCL 1 MSG_LIST,
          2 FILLER1             CHAR(60)       INIT('NAMES MUST BE ALPHABETIC, AND SURNAME IS REQUIRED.'),
          2 FILLER2             CHAR(60)       INIT('ENTER SOME INPUT AND USE ONLY "CLEAR" OR "ENTER".'),
          2 FILLER3             CHAR(60)       INIT('REQUEST TYPE REQUIRED; MUST BE "D", "P", "A", "M" OR "X".'),
          2 FILLER4             CHAR(60)       INIT('PRINTER NAME REQUIRED ON PRINT REQUESTS'),
          2 FILLER5             CHAR(60)       INIT('ACCOUNT NUMBER REQUIRED (BETWEEN 10000 AND 79999).'),
          2 FILLER6             CHAR(60)       INIT('ACCOUNT NO. MUST BE NUMERIC AND FROM 10000 AND 79999'),
          2 FILLER7             CHAR(60)       INIT('NO NAMES ON FILE MATCHING YOUR REQUEST'),
          2 FILLER8             CHAR(60)       INIT('ENTER EITHER NAME OR A REQUEST TYPE AND ACCOUNT NUMBER'),
          2 FILLER9             CHAR(60)       INIT('THIS ACCOUNT NUMBER ALREADY EXISTS'),
          2 FILLER10            CHAR(60)       INIT('NO RECORD OF THIS ACCOUNT NUMBER'),
          2 FILLER11            CHAR(47)       INIT('THIS ACCOUNT NUMBER ALREADY IN USE AT TERMIMAL.'),
          2 MSG_TERM            CHAR(13),
          2 FILLER12            CHAR(60)       INIT('PRINT REQUEST SCHEDULED.'),
          2 FILLER13            CHAR(60)       INIT('PRINTER NAME NOT RECOGNIZED.'),
          2 FILLER14            CHAR(60)       INIT('INPUT ERROR; PLEASE RETRY; USE ONLY "CLEAR OR "ENTER" KEY'),
          2 FILLER15            CHAR(60)       INIT('THERE ARE MORE MATCHING NAMES. PRESS PA2 TO CONTINUE.');

    DCL MSG_TEXT(15)            CHAR(60) DEFINED(MSG_LIST);

    DCL 1 COMMAREA_U            UNION BASED(DFHCOMMAREA),
          2 SRCH_COMM           CHAR(44),
          2 IN_COMM             CHAR(41),
          2 CTYPE               CHAR;

    EXEC CICS HANDLE CONDITION
              MAPFAIL(NO_MAP)
              NOTFND(SRCH_ANY)
              ENDFILE(SRCH_DONE)
              QIDERR(RSRV_1)
              TERMIDERR(TERMID_ERR)
              ERROR(OTHER_ERRORS);

    ACCTMNUI_STRING = LOW(STORAGE(ACCTMNUI));
    ACCTDTLI_STRING = LOW(STORAGE(ACCTDTLI));

    /* CHECK BASIC REQUEST TYPE. */
    IF EIBAID = DFHCLEAR THEN
        IF EIBCALEN = 0 THEN
            DO;
            EXEC CICS SEND CONTROL FREEKB;
            EXEC CICS RETURN;
            END;
        ELSE
            GOTO NEW_MENU;

    IF EIBAID = DFHPA2 & EIBCALEN > 0 & CTYPE = 'S' THEN
        DO;
        SRCH_CTRL = SRCH_COMM;
        GOTO SRCH_RESUME;
        END;

    IF EIBCALEN > 0 & CTYPE = 'R' THEN
       IN_AREA = IN_COMM;

    /* GET INPUT AND CHECK REQUEST TYPE FURTHER. */

    EXEC CICS RECEIVE
              MAP('ACCTMNU')
              MAPSET('ACCTSET');

    IF REQML > 0 THEN
        REQC = REQMI;
    IF REQMF ^= LOW(STORAGE(REQMF)) THEN
        REQC = SPACE;
    IF ACCTML > 0 THEN
        ACCTC = ACCTMI;
    IF ACCTMF ^= LOW(STORAGE(ACCTMF)) THEN
        ACCTC = SPACE;
    IF PRTRML > 0 THEN
        PRTRC = PRTRMI;
    IF PRTRMF ^= LOW(STORAGE(PRTRMF)) THEN
        PRTRC = SPACE;
    IF SNAMEML > 0 THEN
        SNAMEC = SNAMEMI;
    IF SNAMEMF ^= LOW(STORAGE(SNAMEMF)) THEN
        SNAMEC = SPACE;
    IF FNAMEML > 0 THEN
        FNAMEC = FNAMEMI;
    IF FNAMEMF ^= LOW(STORAGE(FNAMEMF)) THEN
        FNAMEC = SPACE;

    ACCTMNUI_STRING = LOW(STORAGE(ACCTMNUI));
    IF STRING(IN_NAMES) = SPACE THEN
        GOTO CK_ANY;

    /* NAME INQUIRY PROCESSING.  VALIDATE NAME INPUT. */

    IF ^ALPHABETIC(FNAMEC) THEN
        DO;
        MSG_NO = 1;
        FNAMEML = -1;
        FNAMEMA = DFHBMBRY;
        END;
    IF SNAMEC = SPACE THEN
        SNAMEMO = STARS;
    ELSE
    IF ALPHABETIC(SNAMEC) THEN
        GOTO CK_NAME;

    MSG_NO = 1;
    SNAMEML = -1;
    SNAMEMA = DFHBMBRY;

CK_NAME:

    IF MSG_NO > 0 THEN
        GOTO MENU_RESEND;

SRCH_INIT: /* BUILD KEY AND LIMITING NAME VALUES FOR SEARCH. */

    BRKEY_SNAME = SNAMEC;
    MAX_SNAME   = SNAMEC;
    BRKEY_ACCT  = LOW(STORAGE(BRKEY_ACCT));
    MAX_SNAME   = TRANSLATE(MAX_SNAME, HIGH(1), SPACE);
    MIN_FNAME   = FNAMEC;
    MAX_FNAME   = FNAMEC;
    MIN_FNAME   = TRANSLATE(MIN_FNAME, LOW(1),  SPACE);
    MAX_FNAME   = TRANSLATE(MAX_FNAME, HIGH(1), SPACE);

SRCH_RESUME: /* INITIALIZE FOR SEQUENTIAL SEARCH. */

    EXEC CICS STARTBR
              DATASET('ACCTIX')
              RIDFLD(BRKEY)
              GTEQ;

SRCH_LOOP: /* BUILD NAME DISPLAY. */

    EXEC CICS READNEXT
              DATASET('ACCTIX')
              INTO(ACIXREC)
              LENGTH(ACIX_LNG)
              RIDFLD(BRKEY);

    IF ACIXREC.SNAMEDO > MAX_SNAME THEN
        GOTO SRCH_DONE;

    IF ACIXREC.FNAMEDO < MIN_FNAME
     | ACIXREC.FNAMEDO > MAX_FNAME THEN
        GOTO SRCH_LOOP;

    LINE_CNT = LINE_CNT + 1;
    IF LINE_CNT > MAX_LINES THEN
        DO;
        MSGMO = MSG_TEXT(15);
        MSGMA = DFHBMBRY;
        GOTO SRCH_DONE;
        END;

    SUM_LINE = ACIXREC, BY NAME;
    SUMLNMO(LINE_CNT) = STRING(SUM_LINE);
    GOTO SRCH_LOOP;

SRCH_DONE:

    EXEC CICS ENDBR DATASET('ACCTIX');

SRCH_ANY:

    IF LINE_CNT = 0 THEN
        DO;
        MSG_NO = 7;
        SNAMEML = -1;
        GOTO MENU_RESEND;
        END;

    /* SEND THE NAME SEARCH RESULTS TO TERMINAL. */
    SUMLNMA(2) = DFHBMUNP;
    SUMLNMA(3) = DFHBMUNP;
    SUMLNMA(4) = DFHBMUNP;
    SUMLNMA(5) = DFHBMUNP;
    SUMLNMA(6) = DFHBMUNP;
    MSGMA      = DFHBMBRY;
    SUMTTLMA   = DFHBMASB;

    EXEC CICS SEND
              MAP('ACCTMNU')
              MAPSET('ACCTSET')
              FREEKB
              DATAONLY
              ERASEAUP;

    IF LINE_CNT <= MAX_LINES THEN
        EXEC CICS RETURN
                  TRANSID('AC01');
    ELSE
        EXEC CICS RETURN
                  TRANSID('AC01')
                  COMMAREA(SRCH_CTRL)
                  LENGTH(44);

CK_ANY:        /* DISPLAY, PRINT, ADD, MODIFY AND DELETE PROCESSING.
          CHECK ACCOUNT NUMBER. */

    IF STRING(IN_REQ) = SPACE THEN
        DO;
        SNAMEML = -1;
        MSG_NO = 8;
        GOTO MENU_RESEND;
        END;

CK_ACCTNO_1:

    IF ACCTC = SPACE THEN
        DO;
        ACCTMO = STARS;
        MSG_NO = 5;
        GOTO ACCT_ERR;
        END;

    IF ACCTC < '10000'
     | ACCTC > '79999'
     | ^NUMERIC(ACCTC) THEN
        DO;
        MSG_NO = 6;
        GOTO ACCT_ERR;
        END;

CK_ACCTNO_2:

    EXEC CICS HANDLE CONDITION
              NOTFND(NO_ACCT_RECORD);

    EXEC CICS READ
              DATASET('ACCTFIL')
              RIDFLD(ACCTC)
              INTO(ACCTREC)
              LENGTH(ACCT_LNG);

    IF REQC = 'A' THEN
        DO;
        MSG_NO = 9;
        GOTO ACCT_ERR;
        END;
    ELSE
        GOTO CK_REQ;

NO_ACCT_RECORD:

    IF REQC = 'A' THEN
        GOTO CK_REQ;

    MSG_NO = 10;

ACCT_ERR:

    ACCTML = -1;
    ACCTMA = DFHBMBRY;

CK_REQ: /* CHECK REQUEST TYPE. */

    IF REQC = 'D'
     | REQC = 'P'
     | REQC = 'A'
     | REQC = 'M'
     | REQC = 'X' THEN
        IF MSG_NO = 0 THEN
            GOTO CK_USE;
       ELSE
            GOTO MENU_RESEND;

    IF REQC = SPACE THEN
        REQMO = STARS;
    REQML = -1;
    REQMA = DFHBMBRY;
    MSG_NO = 3;
    GOTO MENU_RESEND;

CK_USE: /* TEST IF ACCOUNT NUMBER IN USE, ON UPDATES ONLY. */

    IF REQC = 'P'
     | REQC = 'D' THEN
        GOTO BUILD_MAP;

    USE_QID2 = ACCTC;
    EXEC CICS READQ TS
              QUEUE(USE_QID_CHAR)
              INTO(USE_REC)
              ITEM(USE_ITEM)
              LENGTH(USE_LNG);

    USE_TIME = USE_TIME + USE_LIMIT;
    IF USE_TIME > 236000 THEN
        DO;
        USE_DATE = USE_DATE + 1;
        USE_TIME = USE_TIME - 236000;
        END;
    IF USE_DATE > EIBDATE
     | (USE_DATE = EIBDATE & USE_TIME >= EIBTIME) THEN
        DO;
        MSG_TERM = USE_TERM;
        MSG_NO = 11;
        ACCTML = -1;
        ACCTMA = DFHBMBRY;
        GOTO MENU_RESEND;
        END;

RSRV: /* RESERV ACCOUNT NUMBER. */

    USE_TERM = EIBTRMID;
    USE_TIME = EIBTIME;
    USE_DATE = EIBDATE;
    EXEC CICS WRITEQ TS
              QUEUE(USE_QID_CHAR)
              FROM(USE_REC)
              LENGTH(12)
              ITEM(USE_ITEM)
              REWRITE;
    GOTO BUILD_MAP;

RSRV_1:

    USE_TERM = EIBTRMID;
    USE_TIME = EIBTIME;
    USE_DATE = EIBDATE;
    EXEC CICS WRITEQ TS
              QUEUE(USE_QID_CHAR)
              FROM(USE_REC)
              LENGTH(12);

BUILD_MAP: /* BUILD THE RECORD DISPLAY. */

    IF REQC = 'X' THEN
        DO;
        TITLEDO = 'DELETION';
        VFYDL = -1;
        VFYDA = DFHBMUNP;
        MSGDO = 'ENTER "Y" TO CONFIRM OR "CLEAR" TO CANCEL';
        END;
    ELSE
        SNAMEDL = -1;
    IF REQC = 'A' THEN
        DO;
        TITLEDO  = 'NEW RECORD';
        STATTLDA = DFHPROTN;
        LIMTTLDA = DFHPROTN;
        HISTTLDA = DFHPROTN;
        ACCTDI   = ACCTC;
        MSGDO    = 'FILL IN AND PRESS "ENTER," OR "CLEAR" TO CANCEL';
        GOTO SEND_DETAIL;
        END;

    IF REQC = 'M' THEN
        DO;
        TITLEDO = 'RECORD CHANGE';
        MSGDO = 'MAKE CHANGES AND "ENTER" OR "CLEAR" TO CANCEL';
        END;
    ELSE
    IF REQC = 'D' THEN
        MSGDO = 'PRESS "CLEAR" OR "ENTER" WHEN FINISHED';
    ACCTDTLO = ACCTREC, BY NAME;
    PAY_LINE = PAY_HIST(1), BY NAME;
    HIST1DO  = STRING(PAY_LINE);
    PAY_LINE = PAY_HIST(2), BY NAME;
    HIST2DO  = STRING(PAY_LINE);
    PAY_LINE = PAY_HIST(3), BY NAME;
    HIST3DO  = STRING(PAY_LINE);
    IF REQC = 'M' THEN
        GOTO SEND_DETAIL;
    ELSE
    IF REQC = 'P' THEN
        GOTO PRINT_PROC;

    SNAMEDA  = DFHBMASK;
    FNAMEDA  = DFHBMASK;
    MIDA     = DFHBMASK;
    TTLDA    = DFHBMASK;
    TELDA    = DFHBMASK;
    ADDR1DA  = DFHBMASK;
    ADDR2DA  = DFHBMASK;
    ADDR3DA  = DFHBMASK;
    AUTH1DA  = DFHBMASK;
    AUTH2DA  = DFHBMASK;
    AUTH3DA  = DFHBMASK;
    AUTH4DA  = DFHBMASK;
    CARDSDA  = DFHBMASK;
    IMODA    = DFHBMASK;
    IDAYDA   = DFHBMASK;
    IYRDA    = DFHBMASK;
    RSNDA    = DFHBMASK;
    CCODEDA  = DFHBMASK;
    APPRDA   = DFHBMASK;
    SCODE1DA = DFHBMASK;
    SCODE2DA = DFHBMASK;
    SCODE3DA = DFHBMASK;

SEND_DETAIL: /* SEND THE RECORD DETAIL MAP TO THE TERMINAL. */

    EXEC CICS SEND
              MAP('ACCTDTL')
              MAPSET('ACCTSET')
              ERASE
              FREEKB
              CURSOR;

    IF REQC = 'D' THEN
        EXEC CICS RETURN
                  TRANSID('ACCT');
    ELSE
        EXEC CICS RETURN
                  TRANSID('AC02')
                  COMMAREA(IN_REQ)
                  LENGTH(6);

PRINT_PROC: /* START UP A TASK TO PRINT THE RECORD. */

    IF PRTRC = SPACE THEN
        DO;
        PRTRMO = STARS;
        MSG_NO = 4;
        GOTO TERMID_ERR1;
        END;

    EXEC CICS START
              INTERVAL(12)
              TRANSID('AC03')
              FROM(ACCTDTLO)
              LENGTH(DTL_LNG)
              TERMID(PRTRC);

    MSGMO = MSG_TEXT(12);

    EXEC CICS SEND
              MAP('ACCTMNU')
              MAPSET('ACCTSET')
              DATAONLY
              ERASEAUP
              FREEKB;

    EXEC CICS RETURN
              TRANSID('AC01');

TERMID_ERR:

    MSG_NO = 13;
    TERMID_ERR1:
    PRTRML = -1;
    PRTRMA = DFHBMBRY;

MENU_RESEND: /* ERROR PROCESSING, FOR ALL REQUESTS.  RESEND MENU SCREEN.*/

    MSGMO = MSG_TEXT(MSG_NO);
    EXEC CICS SEND
              MAP('ACCTMNU')
              MAPSET('ACCTSET')
              CURSOR
              DATAONLY
              FRSET
              FREEKB;

    EXEC CICS RETURN
              TRANSID('AC01')
              COMMAREA(IN_AREA)
              LENGTH(41);

NO_MAP: /* PROCESSING FOR MAP FAILURES, CLEARS. */

    IF EIBAID = DFHPA1
     | EIBAID = DFHPA2
     | EIBAID = DFHPA3
     | EIBAID = DFHENTER THEN
        DO;
        MSG_NO = 2;
        SNAMEML = -1;
        GOTO MENU_RESEND;
        END;

    MSGMO = MSG_TEXT(14);

NEW_MENU:

    EXEC CICS SEND
              MAP('ACCTMNU')
              MAPSET('ACCTSET')
              FREEKB
              ERASE;

    EXEC CICS RETURN
              TRANSID('AC01');

OTHER_ERRORS: /* PROCESSING FOR UNEXPECTED ERRORS. */

    ERR_FN = EIBFN;
    ERR_RCODE = EIBRCODE;
    EXEC CICS HANDLE CONDITION ERROR;
    EXEC CICS LINK
              PROGRAM('ACCT04')
              COMMAREA(COMMAREA_FOR_ACCT04)
              LENGTH(10);

END ACCT01;
