/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2005 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/

/*
 *  ACCT04 is a general purpose error routine.  Control is trans-
 *  ferred  to  it  by other programs in the on-line account file
 *  application when an unrecoverable  error  has  occurred.   It
 *  sends a message to input terminal describing the type of error
 *  and  asks  the operator to report it, then it abends, so that
 *  any updates made in the uncompleted transaction are backed out
 *  and so that an abend dump is available.
 *
 */

ACCT04: PROCEDURE OPTIONS(MAIN);

%INCLUDE 'ACCTSET.inc';

    DCL ACCTERRO_STRING CHAR(STORAGE(ACCTERRO)) DEFINED(ACCTERRO);

    DCL 1 MISC,
          2 I                   FIXED BIN(15),
          2 IX                  FIXED BIN(15)   INIT(+31),
          2 DSN_MSG_U           UNION,
            4 DSN_MSG_CHAR      CHAR(22),
            4 DSN_MSG_S,
              6 FILLER1         CHAR(13)        INIT('THE FILE IS: '),
              6 DSN             CHAR(8),
              6 FILLER2         CHAR            INIT('.'),
          2 HEX_U               UNION,
            4 HEX_CODE(31)      CHAR(2),
            4 HEX_LIST,
              6 HEX_0601        FIXED BIN(15)   INIT(+1537),
              6 HEX_0602        FIXED BIN(15)   INIT(+1538),
              6 HEX_0608        FIXED BIN(15)   INIT(+1544),
              6 HEX_060C        FIXED BIN(15)   INIT(+1548),
              6 HEX_060F        FIXED BIN(15)   INIT(+1551),
              6 HEX_0680        FIXED BIN(15)   INIT(+1664),
              6 HEX_0681        FIXED BIN(15)   INIT(+1665),
              6 HEX_0682        FIXED BIN(15)   INIT(+1666),
              6 HEX_0683        FIXED BIN(15)   INIT(+1667),
              6 HEX_06E1        FIXED BIN(15)   INIT(+1761),
              6 HEX_0A01        FIXED BIN(15)   INIT(+2561),
              6 HEX_0A02        FIXED BIN(15)   INIT(+2562),
              6 HEX_0A04        FIXED BIN(15)   INIT(+2564),
              6 HEX_0A08        FIXED BIN(15)   INIT(+2568),
              6 HEX_0A20        FIXED BIN(15)   INIT(+2592),
              6 HEX_0AE1        FIXED BIN(15)   INIT(+2785),
              6 HEX_0E01        FIXED BIN(15)   INIT(+3585),
              6 HEX_0EE1        FIXED BIN(15)   INIT(+3809),
              6 HEX_1001        FIXED BIN(15)   INIT(+4097),
              6 HEX_1004        FIXED BIN(15)   INIT(+4100),
              6 HEX_1011        FIXED BIN(15)   INIT(+4113),
              6 HEX_1012        FIXED BIN(15)   INIT(+4114),
              6 HEX_1014        FIXED BIN(15)   INIT(+4116),
              6 HEX_1081        FIXED BIN(15)   INIT(+4225),
              6 HEX_10E1        FIXED BIN(15)   INIT(+4321),
              6 HEX_10E9        FIXED BIN(15)   INIT(+4329),
              6 HEX_10FF        FIXED BIN(15)   INIT(+4351),
              6 HEX_1804        FIXED BIN(15)   INIT(+6148),
              6 HEX_1808        FIXED BIN(15)   INIT(+6152),
              6 HEX_18E1        FIXED BIN(15)   INIT(+6369),
              6 HEX_MISC        FIXED BIN(15)   INIT(+0001),
          2 ERR_U               UNION,
            4 ERR_MSG(31)       CHAR(60),
            4 ERR_LIST,
              6 MSG_0601        CHAR(60)        INIT('A PROGRAM OR FCT TABLE ERROR (INVALID FILE NAME).'),
              6 MSG_0602        CHAR(60)        INIT('A PROGRAM OR FILE ERROR (VSAM ILLOGIC).'),
              6 MSG_0608        CHAR(60)        INIT('A PROGRAM OR FCT TABLE ERROR (INVALID FILE REQUEST).'),
              6 MSG_060C        CHAR(60)        INIT('A FILE BEING CLOSED THAT MUST BE OPEN.'),
              6 MSG_060F        CHAR(60)        INIT('A PROGRAM OR FILE ERROR (UNEXPECTED END-OF-FILE).'),
              6 MSG_0680        CHAR(60)        INIT('A FILE INPUT/OUTPUT ERROR.'),
              6 MSG_0681        CHAR(60)        INIT('A PROGRAM OR FILE ERROR (RECORD NOT FOUND).'),
              6 MSG_0682        CHAR(60)        INIT('A PROGRAM OR FILE ERROR (DUPLICATE RECORD).'),
              6 MSG_0683        CHAR(60)        INIT('INADEQUATE SPACE IN A FILE.'),
              6 MSG_06E1        CHAR(60)        INIT('A PROGRAM OR FILE ERROR (LENGTH ERROR, FILE CONTROL).'),
              6 MSG_0A01        CHAR(60)        INIT('A PROGRAM OR TEMPORARY STORAGE ERROR (ITEM ERROR).'),
              6 MSG_0A02        CHAR(60)        INIT('A PROGRAM OR TEMPORARY STORAGE ERROR (UNKNOWN QUEUE).'),
              6 MSG_0A04        CHAR(60)        INIT('AN INPUT/OUTPUT ERROR IN TEMPORARY STORAGE.'),
              6 MSG_0A08        CHAR(60)        INIT('NO SPACE IN TEMPORARY STORAGE.'),
              6 MSG_0A20        CHAR(60)        INIT('A PROGRAM OR SYSTEM ERROR (INVALID REQUEST IN TS).'),
              6 MSG_0AE1        CHAR(60)        INIT('A PROGRAM OR TEMPORARY STORAGE ERROR (TS LENGTH ERROR).'),
              6 MSG_0E01        CHAR(60)        INIT('A PROGRAM OR PPT TABLE ERROR (UNKNOWN PROGRAM NAME).'),
              6 MSG_0EE0        CHAR(60)        INIT('A PROGRAM ERROR (INVALID PROGRAM REQUEST).'),
              6 MSG_1001        CHAR(60)        INIT('A PROGRAM ERROR (END OF DATA, USING IC).'),
              6 MSG_1004        CHAR(60)        INIT('AN INPUT/OUTPUT ERROR IN TEMPORARY STORAGE (USING IC).'),
              6 MSG_1011        CHAR(60)        INIT('A PROGRAM OR PCT TABLE ERROR (TRANSID ERROR USING IC).'),
              6 MSG_1012        CHAR(60)        INIT('A PROGRAM OR TCT TABLE ERROR (TERMIDERR USING IC).'),
              6 MSG_1014        CHAR(60)        INIT('A PROGRAM OR SYSTEM ERROR (INVTSREQ USING IC).'),
              6 MSG_1081        CHAR(60)        INIT('A PROGRAM OR SYSTEM ERROR (INVTSREQ USING IC).'),
              6 MSG_10E1        CHAR(60)        INIT('A PROGRAM OR TEMP STORAGE ERROR (NOT FOUND USING IC).'),
              6 MSG_10E9        CHAR(60)        INIT('A PROGRAM ERROR (INVALID REQUEST USING IC).'),
              6 MSG_10FF        CHAR(60)        INIT('A PROGRAM ERROR (ENVDEFERR USING IC).'),
              6 MSG_1804        CHAR(60)        INIT('A PROGRAM ERROR (BMS MAPFAIL).'),
              6 MSG_1808        CHAR(60)        INIT('A PROGRAM ERROR (INVALID MAP SIZE).'),
              6 MSG_18E1        CHAR(60)        INIT('A PROGRAM ERROR (BMS LENGTH ERROR).'),
              6 MSG_MISC        CHAR(60)        INIT('AN UNKNOWN TYPE OF ERROR.');

    DCL 1 COMMAREA              BASED(DFHCOMMAREA),
          2 ERR_PGRMID          CHAR(8),
          2 ERR_CODE,
            4 ERR_FN            CHAR,
            4 ERR_RCODE         CHAR;

    ACCTERRO_STRING = LOW(STORAGE(ACCTERRO));

    DO I = 1 TO IX UNTIL (I >= IX);
        IF HEX_CODE(I) = STRING(ERR_CODE) THEN
            IX = I;
    END;

    RSNEO  = ERR_MSG(IX);
    TRANEO = EIBTRNID;
    PGMEO  = ERR_PGRMID;
    IF IX < 11 THEN
        DO;
        DSN = EIBDS;
        FILEEO = DSN_MSG_CHAR;
        END;

    EXEC CICS SEND
              MAP('ACCTERR')
              MAPSET('ACCTSET')
              ERASE
              FREEKB;

    EXEC CICS ABEND ABCODE('EACC');

END ACCT04;
