package com.sun.mfwk.util.instrum;
 
import java.util.logging.*;
import com.sun.mfwk.util.log.MfLogService;


/**
 * MFTimersJNI provides a way to call gethrtime(),
 * gethrvtime() and enableMicrostateAccounting().
 * These are primarily Solaris concepts, though
 * we provide an interpretation for gethrvtime()
 * on Linux, which is accurate only to 10ms.
 * In any case, if the function is called on a platform where
 * it is not supported it will return -1.
 * 
 */

class MfTimersJNI {
  
    /**
     *Get the highrestimer tick.
     */
    public native long mfGethrtime();

    /**
     * Get the highrestimer cpu tick.
     * For measuring the cpu time per thread. 
     */
    public native long mfGethrvtime();

    /**
     * Enable microstate accounting.
     * If microstate accounting is not enabled
     * then the accuracy of the gethrvtime() call
     * is only 10ms.  Once it is enabled
     * the accuracy 100 microseconds.
     * The same effect can be achieved by starting the jvm
     * with ptime(1) on Solaris.
     */
    public native int mfEnableMicrostateAccounting();

    /**
     * Disbale microstate accounting:
     * 
     */
    public native int mfDisbaleMicrostateAccounting();

    private static Logger logger = MfLogService.getLogger("UtilInstrum"); 

    static {
      try{          
		  logger.fine("java.library.path=" +
                             System.getProperty("java.library.path"));
          System.loadLibrary("mfTimersJNI"); 
         
      } catch(SecurityException e) {

          logger.warning("Failed to load library libmfTimers.so" +
                         "Security Exception: " + e.getMessage() );          
      } catch(UnsatisfiedLinkError e) {
          logger.warning("Failed to load library libmfTimers.so" +
                         "Unsatisfied link Exception: " + e.getMessage() );    
      }
  }



}
