/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfStatus.java 1.8     04/06/25 SMI"
 *
 */

package com.sun.mfwk.util.instrum;

import javax.management.*;
import java.util.logging.*;
import com.sun.mfwk.util.log.MfLogService;


/**
 * MfStatusMBean contains the status of a component product
 */

public class  MfStatus extends NotificationBroadcasterSupport implements MfStatusMBean {

    // No specific constructor

    // Public Instance Methods

    ////////////////////////////
    //
    // Getters
    //
    ////////////////////////////

    /**
     * Get the availability state.
     */
    public int getAvailabilityState() {
	return availabilityState;
    }

    /**
     * Get the availability state last change time.
     * The returned value is the number of milliseconds since January 1, 1970, 00:00:00.
     */
    public long getAvailStateLastChange() {
	return availStateLastChange;
    }

    /**
     * Get the time the component product has entered in a degraded or congested state.
     * The returned value is the number of milliseconds since January 1, 1970, 00:00:00.
     */
    public long getDegradedTime() {
	return degradedTime;
    }

    /**
     * Get the operational state.
     */
    public int getOperationalState() {
	return operationalState;
    }

    /**
     * Get the operational state last change time.
     * The returned value is the number of milliseconds since January 1, 1970, 00:00:00.
     */
    public long getOpsStateLastChange() {
	return opsStateLastChange;
    }

    /**
     * Get the time the component product has entered in a running state.
     * The returned value is the number of milliseconds since January 1, 1970, 00:00:00.
     */
    public long getRunningTime() {
	return runningTime;
    }



    ////////////////////////////
    //
    // Setters
    //
    ////////////////////////////

    /**
     * Set the availability state.
     */
    public synchronized void setAvailabilityState(int state) {
	logger.entering("MfStatus", "setAvailabilityState", new Integer(state));
	availabilityState = state;
    }

    /**
     * Set the availability state last change time.
     * The value is the number of milliseconds since January 1, 1970, 00:00:00.
     */
    public synchronized void setAvailStateLastChange(long time) {
	logger.entering("MfStatus", "setAvailStateLastChange", new Long(time));
	availStateLastChange = time;
    }

    /**
     * Set the time the component product has entered in a degraded or congested state.
     * The value is the number of milliseconds since January 1, 1970, 00:00:00.
     */
    public synchronized void setDegradedTime(long time) {
	logger.entering("MfStatus", "setDegradedTime", new Long(time));
	degradedTime = time;
    }

    /**
     * Set the operational state.
     */
    public synchronized void setOperationalState(int state) {
	logger.entering("MfStatus", "setOperationalState", new Integer(state));
	operationalState = state;
    }

    /**
     * Set the operational state last change time.
     * The value is the number of milliseconds since January 1, 1970, 00:00:00.
     */
    public synchronized void setOpsStateLastChange(long time) {
	logger.entering("MfStatus", "setOpsStateLastChange", new Long(time));
	opsStateLastChange = time;
    }

    /**
     * Set the time the component product has entered in a running state.
     * The value is the number of milliseconds since January 1, 1970, 00:00:00.
     */
    public synchronized void setRunningTime(long time) {
	logger.entering("MfStatus", "setRunningTime", new Long(time));
	runningTime = time;
    }


    // Private variables
    private int availabilityState = 0;
    private long availStateLastChange = 0;
    private long degradedTime = 0;
    private int operationalState = 0;
    private long opsStateLastChange = 0;
    private long runningTime = 0;

    private static Logger logger = MfLogService.getLogger("UtilInstrum");    
}
