/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfResourceMetricsMBean.java 1.3     04/05/19 SMI"
 *
 */

package com.sun.mfwk.util.instrum; 

import javax.management.*;

/**
 * MfResourceMetricsMBean contains the generic metrics related to a resource.
 */

public interface  MfResourceMetricsMBean extends MfMetricMBean {

    /**
     * Get the number of failed operations.
     */
    public long getFailedOperations();

    /**
     * Get the number of operations.
     */
    public long getNbOperations();

    /**
     * Get the minimum operation time since the reference time.
     */
    public long getMinOperationTime();

    /**
     * Get the maximum operation time since the reference time.
     */
    public long getMaxOperationTime();

    /**
     * Get the accumulated operation time since the reference time.
     */
    public long getAccumulatedOperationTime();

    /**
     * Get the accumulated squared operation time since the reference time.
     */
    public long getAccumulatedSqOperationTime();


}
