/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfMetricMBean.java 1.4     04/05/19 SMI"
 *
 */

package com.sun.mfwk.util.instrum;

import javax.management.*;

/**
 * MfMetricMBean contains the generic information exposed for management for all metric types
 */

public interface MfMetricMBean extends MfStatusMBean {

    // Getters

    /**
     * Check if the instrumentation is disabled for this instance.
     */
    public boolean isMonitoringEnabled();


    // Setters


    // Operations

    /**
     * Reset all the metrics.
     */
    public abstract void resetMetrics();

    /**
     * Enables the monitoring for this instance.
     */
    public void enableMonitoring();


    /**
     * Disables the monitoring for this instance.
     */
    public void disableMonitoring();  
}
