/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfInstrumManagement.java 1.9     04/05/19 SMI"
 *
 */

package com.sun.mfwk.util.instrum;

import javax.management.*;
import java.util.logging.*;
import com.sun.mfwk.util.log.MfLogService;

/**
 * MfInstrumManagementMBean allows instrumentation management.
 */


public class MfInstrumManagement extends NotificationBroadcasterSupport implements MfInstrumManagementMBean {
    
    // Constructor
    public MfInstrumManagement() {
	// Get the log level
	logLevel = logger.getLevel();
    }

    // Getters

    /**
     * Check if the monitoring is enabled.
     * If the monitoring is disabled, all the MBeans implementing instrumentation 
     * should be unregistered from the MBeanServer.
     */
    public boolean isMonitoringEnabled() {
	return monitoringEnabled;
    }

    /**
     * Get the logging level..
     */
    public Level getLoggingLevel() {
	return MfLogService.getLoggingLevel();
    }    
    
    // Setters

    /**
     * Set the logging level.
     */
    public synchronized void setLoggingLevel(Level level) {
	logger.entering("MfInstrumManagement", "setLoggingLevel", level);
	MfLogService.setLoggingLevel(level);
    }
    

    // Operations

    /**
     * Enables the monitoring.
     * This mean that all the instrumentation will be enabled.
     */
    public synchronized void enableMonitoring() {
	logger.entering("MfInstrumManagement", "enableMonitoring");
	if (isMonitoringEnabled())
	    return;
	monitoringEnabled = true;

	// send notification
	logger.finest("Send notification: MonitoringEnabled");
        AttributeChangeNotification acn = new AttributeChangeNotification(
            this, 0, 0, null, "MonitoringEnabled", null, null, null);
        sendNotification(acn);
    }


    /**
     * Disables the monitoring.
     * This mean that all the instrumentation will be disabled.
     */
    public synchronized void disableMonitoring() {
	logger.entering("MfInstrumManagement", "disableMonitoring");
	if (!isMonitoringEnabled())
	    return;
	monitoringEnabled = false;

	// send notification
	logger.finest("Send notification: MonitoringDisabled");
        AttributeChangeNotification acn = new AttributeChangeNotification(
            this, 0, 0, null, "MonitoringDisabled", null, null, null);
        sendNotification(acn);
    }

    private boolean monitoringEnabled = true;
    private Level logLevel = Level.OFF;

    private static Logger logger = MfLogService.getLogger("UtilInstrum");
}
