/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfExternalResourceMetricsMBean.java 1.4     04/05/19 SMI"
 *
 */

package com.sun.mfwk.util.instrum; 

import javax.management.*;

/**
 * MfExternalResourceMetricsMBean contains the metrics related to an external resource.
 */

public interface  MfExternalResourceMetricsMBean extends MfMetricMBean {

	
    /**
     * Get the uri of the external resource.
     */
    public String getProviderUri();
	
    /**
     * Get the total number of associations since the initialization.
     */
    public long getAccumulatedOutboundAssociations();
	
    /**
     * Get the total number of failed associations since the initialization.
     */
    public long getFailedOutboundAssociations();
	
    /**
     * Get the number of failed queries.
     */
    public long getFailedQueries();

    /**
     * Get the number of queries.
     */
    public long getNbQueries();
	
    /**
     * Get the value of sysUpTime at the time this application last had an outbound association..
     */
    public long getLastOutboundActivity();
	
    /**
     * Get the number of current associations.
     */
    public long getOutboundAssociations();
	
    /**
     * Get the minimum query time.
     */
    public long getMinQueriesTime();
	
    /**
     * Get the maximum query time.
     */
    public long getMaxQueriesTime();
	
    /**
     * Get the accumulated query time.
     */
    public long getAccumulatedQueriesTime();
	
    /**
     * Get the accumulated squared query time.
     */
    public long getAccumulatedSqQueriesTime();

}
