/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfTransactionFactoryImpl.java 1.8     04/10/06 SMI"
 *
 */

package com.sun.mfwk.trans;

import com.sun.mfwk.util.instrum.*;

/**
 * Implementation of the MfTransactionFactory interface
 */

public class MfTransactionFactoryImpl implements MfTransactionFactory {

    public MfTransactionDefinition newTransactionDefinition(
							  String name,
							  String uri,
							  MfTransactionMetrics transMetrics) {
	return new MfTransactionDefinitionImpl(name, uri, transMetrics);
    }

    public MfTransactionDefinition newTransactionDefinition(
							  String name,
							  String uri,
							  MfTransactionMetrics transMetrics,
							  boolean hasComputingInfo) {
	return new MfTransactionDefinitionImpl(name, uri, transMetrics, hasComputingInfo);
    }

    public MfTransaction newTransaction(MfTransactionDefinition definition, MfTransaction parentTrans) {
	return new MfTransactionImpl(definition, parentTrans);
    }

    public MfTranReport newTranReport(MfTransactionDefinition definition, MfTranReport parentTrans) {
	return new MfTranReportImpl(definition, parentTrans);
    }

}
