/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfTransactionFactory.java 1.7     04/10/06 SMI"
 *
 */

package com.sun.mfwk.trans; 

/**
 * MfTransactionFactory provides methods to create the transaction API objects.
 */

public interface MfTransactionFactory {

    // Public Instance Methods


    /**
     * Creates a new transaction type.
     *<p>
     *<p>
     *@return TransactionDefinition
     *@param name name of the transaction type.
     *@param uri the related URI.
     *@param transMetrics the transaction metrics MBean.
     */
    public MfTransactionDefinition newTransactionDefinition(
							  String name,
							  String uri,
							  MfTransactionMetrics transMetrics);

    /**
     * Creates a new transaction type.
     *<p>
     *<p>
     *@return TransactionDefinition
     *@param name name of the transaction type.
     *@param uri the related URI.
     *@param transMetrics the transaction metrics MBean.
     *@param hasComputingInfo only valid for parent transactions: if true, the corresponding transaction has its own computing metrics.If false, the parent transaction is only an aggregation of a set of transactions. The default is true.
     */
    public MfTransactionDefinition newTransactionDefinition(
							  String name,
							  String uri,
							  MfTransactionMetrics transMetrics,
							  boolean hasComputingInfo);

    /**
     * Creates a new transaction.
     *<p>
     *<p>
     *@return Transaction
     *@param definition the related MfTransactionDefinition (ie transaction type).
     *@param parentTrans the parent transaction. May be null.
     */
    public MfTransaction newTransaction(MfTransactionDefinition definition, MfTransaction parentTrans);


    /**
     * Creates a new transaction report.
     *<p>
     *<p>
     *@return TranReport
     *@param definition the related MfTransactionDefinition (ie transaction type).
     *@param parentTrans the parent transaction. May be null.
     */
    public MfTranReport newTranReport(MfTransactionDefinition definition, MfTranReport parentTrans);

}
