/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfTransactionDefinition.java 1.4     04/10/06 SMI"
 *
 */

package com.sun.mfwk.trans;

import java.util.*;


/**
 * MfTransactionDefinition defines a transaction type.
 * It is created with the newTransactionDefinition() method of MfTransactionFactory.
 */

public interface MfTransactionDefinition extends MfTranInterface {

    // No Public Constructors

    // Public Instance Methods

    /**
     * Returns the name of the transaction type.
     */
    public String getName();

    /**
     * Returns the uri of the transaction type.
     */
    public String getUri();

    /**
     * Returns the generated ID of the transaction type.
     */
    public int getID();

    /**
     * Returns the transaction metrics MBean for this transaction type.
     */
    public MfTransactionMetrics getTransactionMetrics();

    /**
     * Check if this transaction definition has its own computing metrics. Only valid for parent transactions.
     */
    public boolean hasComputingInfo();

}
