/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfTransaction.java 1.8     04/10/06 SMI"
 *
 */

package com.sun.mfwk.trans; 

/**
 * MfTransaction defines a transaction instance (start/stop mode).
 * It is created with the newTransaction() method of MfTransactionFactory.
 */

public interface MfTransaction extends MfGenericTransaction, MfTranInterface {

    // No Public Constructors

    // Public Instance Methods

    /**
     * Indicates that the transaction is beginning execution.
     */
    public int start();

    /**
     * Signals the end of the transaction.
     *<p>
     *<p>
     *@param status the status of the transaction (one of the constants in MfConstants)
     */
    public int stop(int status);

    /**
     * Signals the end of the transaction.
     * Assume the transaction status is OK.
     */
    public int stop();

    /**
     * Indicates that the transaction instance is blocked waiting on an external transaction
     * (which may or may not be instrumented with this API).
     */
    public int block();

    /**
     * Indicates the end of an external transaction.
     */
    public int unblock();

}
