/*
 * MfPassword.java
 *
 * Created on May 11, 2004, 6:13 PM
 */

package com.sun.mfwk.security.password;

import java.util.Random;

/** Class to generate randomly computed password.
 * 
 * @author ooudghir
 */
public class MfPassword {
    
    /** Generates a random password.
     * @param n Number of characters of the password.
     * Must be positive, otherwise as null string is returned.
     * @return the generated password or null if n is negative or null
     */    
    public static String getMfPassword(int n) {
        Random rnd = new Random();
        String password = "";
        int c = 0;
        if (n <= 0)
            return null;
        
        for (int i=0; i<n; ++i) {
            int j = rnd.nextInt(3);
            switch (j) {
        case 0: c = '0' +  rnd.nextInt(10); break;
        case 1: c = 'a' +  rnd.nextInt(26); break;
        case 2: c = 'A' +  rnd.nextInt(26); break;
      }
      password += (char) c;
        }
        return password;
    }
    
    public static void main(String args[]) {
        System.out.println(getMfPassword(128));  
    }
    
}
