/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "%Z%%M% %I%     %E% SMI"
 *
 */

package com.sun.mfwk.discovery;

import java.io.EOFException;
import java.io.IOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class MfTypeIOUtil
{
    public static final short SIZEOF_BYTE = 1;
    public static final short SIZEOF_SHORT = 2;
    public static final short SIZEOF_LONG = 8;

    public static short readShort( final ByteArrayInputStream input )
        throws IOException
    {
        return (short) ( ( read( input ) << 8 ) + read( input ) );
    }

    public static void writeShort( final ByteArrayOutputStream output,
                                   final short value ) throws IOException
    {
        output.write( (byte) ( ( value >> 8 ) & 0xff ) );
        output.write( (byte) ( ( value >> 0 ) & 0xff ) );
    }

    public static long readLong( final ByteArrayInputStream input )
        throws IOException
    {
        return (long) ( ( read( input ) << 56 ) + 
                        ( read( input ) << 48 ) + 
                        ( read( input ) << 40 ) + 
                        ( read( input ) << 32 ) + 
                        ( read( input ) << 24 ) + 
                        ( read( input ) << 16 ) + 
                        ( read( input ) << 8 ) + 
                          read( input ) );
    }

    public static void writeLong( final ByteArrayOutputStream output,
                                   final long value ) throws IOException
    {
        output.write( (byte) ( ( value >> 56 ) & 0xff ) );
        output.write( (byte) ( ( value >> 48 ) & 0xff ) );
        output.write( (byte) ( ( value >> 40 ) & 0xff ) );
        output.write( (byte) ( ( value >> 32 ) & 0xff ) );
        output.write( (byte) ( ( value >> 24 ) & 0xff ) );
        output.write( (byte) ( ( value >> 16 ) & 0xff ) );
        output.write( (byte) ( ( value >> 8 ) & 0xff ) );
        output.write( (byte) ( ( value >> 0 ) & 0xff ) );
    }
    
    
    private static long read( final ByteArrayInputStream input ) throws IOException
    {
        final long value = input.read();
        if( -1 == value )
        {
            throw new EOFException( "Unexpected EOF reached" );
        }
        return value;
    }
    
    
/**

* Convert a byte[] array to readable string format. This makes the "hex"
readable!

* @return result String buffer in String format 

* @param in byte[] buffer to convert to string format

*/

    protected static String byteArrayToHexString(byte in[]) {
        
        byte ch = 0x00;
        int i = 0;
        if (in == null || in.length <= 0)
            return "Array is null or empty";
        String pseudo[] = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(in.length * 2);
        
        while (i < in.length) {            
            ch = (byte) (in[i] & 0xF0); // Strip off high nibble
            ch = (byte) (ch >>> 4); // shift the bits down
            ch = (byte) (ch & 0x0F); // must do this is high order bit is on!
            out.append("[0x"); // convert the nibble to a String Character
            out.append(pseudo[ (int) ch]); // convert the nibble to a String Character
            ch = (byte) (in[i] & 0x0F); // Strip off low nibble
            out.append(pseudo[ (int) ch]); // convert the nibble to a String Character
            out.append("]"); // convert the nibble to a String Character
            i++;            
        }        
        String rslt = new String(out);        
        return rslt;
    }    

    protected static String boolToString(boolean b) {
        Boolean bool = new Boolean(b);
        return bool.toString();
    }    

    
}
