/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfDiscoveryInfo.java 1.7     04/07/21 SMI"
 *
 */

package com.sun.mfwk.discovery;

/*
 * MfDiscoveryInfo.java
 *
 * Created on May 4, 2004, 3:17 PM
 */

/** A discovery client is registered in the agent (MfDiscoveryService) and notifies
 * CP module that have registered themselves to provide them with discovery
 * RESPONSE message that are received from the CP instances unning on the node.
 *
 * The notification is a JMX notification. The notification type is set to the
 * product name (this enables CP module to filter the notification they are interested in).
 * The object received in the notification has to be casted to a MfDiscoveryInfo object on which
 * you can apply the methods listed below to retrieve the informations filled in the DiscoveryResponder
 * object.
 * @author Sun Microsystems
 */
public interface MfDiscoveryInfo {
    
    /** Returns a String containing the product name that has been detected
     * @return Returns a String containing the product name that has been detected
     */    
    String getProduct();
    
    /** Returns a String containing the product instance name that has been detected
     * @return Returns a String containing the product instance name that has been detected
     */    
    String getProductInstance();
    
    /** Returns a String containing the URI where the instrumentation for the
     * (product,productInstance) that has been detected can be reached
     * @return Returns a String containing the URI where the instrumentation for the product that has been detected
     * can be reached
     */    
    String getUri();
    
    /** Returns a byte[] containing the UserData belonging to the (product,productInstance) that has been detected
     * @return Returns a byte[] containing the UserData belonging to the (product,productInstance) that has been detected
     */    
    byte[] getUserData();

    /** Returns a long containing the timestamp taken when the instance was started 
     * @return a long containing the timestamp taken when the instance was started 
     */    
    long getTimeStamp();
}
