/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBStats.java 1.15     04/06/17 SMI"
 *
 */

package com.sun.mfwk.cib.statistics;

import javax.management.j2ee.statistics.Stats;
import com.sun.mfwk.cib.providers.CIBProvider;
import javax.management.openmbean.CompositeData;

import javax.management.openmbean.OpenDataException;

/**
 * Provides methods that should implemented by a CIBStats
 */
public interface CIBStats
    extends Stats, CIBProvider {

  /**
   * Version of the Statistics model
   */
  public static String CIBStatsVersion = "Statistics Model version 1.0";

  /**
  * Returns a CompositeData object based on the Statistic object
   * @throws OpenDataException
   * @return CompositeData
   */
  public CompositeData toCompositeData() throws OpenDataException;

 /**
  * Returns a CIBStatistic object based on the composite data
  * @return CIBStatistic
  */
 public CIBStats fromCompositeData(CompositeData data);

}
