/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBExternalResourcePerfStats.java 1.13     04/06/17 SMI"
 *
 */

package com.sun.mfwk.cib.statistics;

import com.sun.mfwk.cib.CIBIOException;
import com.sun.mfwk.cib.CIBAttributeNotFoundException;

/**
 * Provides methods that should be implemented by a CIBExternalServiceStats object
 */
public interface CIBExternalResourcePerfStats
    extends CIBPerfStats {

  ///////////////////////////////////////
  // operations

  /**
   * Returns a Statistic representing the total number of associations to the application entity
   * since application initialization, where it was the initiator.
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBValueStatistic
   */
  public CIBValueStatistic getAccumulatedOutboundAssociations() throws
      CIBIOException, CIBAttributeNotFoundException;

  /**
   * Returns a Statistic representing the total number associations where the application entity
   * is initiator and association establishment has failed,
   * since application initialization.  Failed associations are
   * not counted in the accumulated association totals."
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBValueStatistic
   */
  public CIBValueStatistic getFailedOutboundAssociations() throws
      CIBIOException, CIBAttributeNotFoundException;

  /**
   * Return a Statistic representing the number of current associations to the network service
   * application, where it is the initiator.  An outbound
   * association occurs when this application successfully
   * connects to another one.
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBValueStatistic
   */
  public CIBValueStatistic getOutboundAssociations() throws CIBIOException,
      CIBAttributeNotFoundException;

  /**
   * Returns a Statistic representing the value of sysUpTime at the time this application last
   * had an outbound association.
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBValueStatistic
   */
  public CIBValueStatistic getLastOutboundActivity() throws CIBIOException,
      CIBAttributeNotFoundException;

  /**
   * Returns a Statistic object representing the time for queries
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBTimeStatistic
   */
  public CIBTimeStatistic getQueriesTime() throws CIBIOException,
      CIBAttributeNotFoundException;

  /**
   * Returns a Statistic object containing the number of failed queries
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBValueStatistic
   */
  public CIBValueStatistic getFailedQueries() throws CIBIOException,
      CIBAttributeNotFoundException;

}
