/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBState.java 1.15     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib.states;

import com.sun.mfwk.cib.providers.CIBProvider;
import com.sun.mfwk.cib.CIBIOException;
import com.sun.mfwk.cib.CIBAttributeNotFoundException;

/**
 * Provides methods that should be implemented by a CIBState object
 */
public interface CIBState
    extends CIBProvider {

  /**
   * Returns the time the last change of the state occurred
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return long
   */
  public long getLastChange() throws CIBIOException,
      CIBAttributeNotFoundException;

  /**
   * Returns the state
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return int
   */
  public int getState() throws CIBIOException, CIBAttributeNotFoundException;

  /**
   * Returns the state into a String format
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return String
   */
  public String toStateString() throws CIBIOException,
      CIBAttributeNotFoundException;

}
