/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBOperationalStatusState.java 1.14     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib.states;

import com.sun.mfwk.cib.CIBIOException;
import com.sun.mfwk.cib.CIBAttributeNotFoundException;

/**
 * The State model specifies the attributes that a compliant JES managed object
 * must implement. A managed object (MBean) which implements the State
 * model could generate events when the operational status changes of state.
 */
public interface CIBOperationalStatusState
    extends CIBState {

  /**
   * Indicates that the managed object has been requested to start, and is in the
   * process of starting. On entering that state, the managed object may generate an
   * event.
   * Support of the STARTING state is optional for all managed objects implementing
   * the StateManageable model.
   */
  public static final int STARTING = 0;

  /**
   * Indicates that the managed object is operational and ready to handle requests.
   * On entering this state, a managed object may generate an event .
   * Support of the RUNNING state is required for all managed objects implementing
   * the StateManageable model.
   */
  public static final int RUNNING = 1;

  /**
   * Indicates that the managed object has entered a quiet state resulting
   * from an administrative stop request. The managed object is no longer operational
   * and may not be able to handle further requests. On entering this state,
   * a managed object may generate an event.
   * Support of the STOPPING state is optional for the managed objects supporting
   * the StateManageable model.
   */
  public static final int STOPPING = 2;

  /**
   * Indicates that the monitoring object has stopped and can be restarted.
   * On entering this state the managed object may generate an event.
   * Support of the STOPPED state is required by all managed objects implementing
   * the StateManageable model.
   */
  public static final int STOPPED = 3;

  /**
   * Indicates that the managed object has unexpectedly stopped.
   * On entering this state the managed object may generate an event.
   * Support of the FAILED state is required by all managed objects implementing
   * the StateManageable model.
   */
  public static final int FAILED = 4;

  /**
   * Returns the time the managed object was started.
   * (i.e. entered the RUNNING state) represented as a Double,
   * which value is the number of milliseconds since January 1, 1970, 00:00:00.
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return long
   */
  public long getStartTime() throws CIBIOException,
      CIBAttributeNotFoundException;

}
