/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBAvailabilityStatusState.java 1.14     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib.states;

import com.sun.mfwk.cib.CIBIOException;
import com.sun.mfwk.cib.CIBAttributeNotFoundException;

/**
 * The State model specifies the attributes that a compliant Java ES managed object
 * must implement. A managed object (MBean) which implements the State
 * model could generate events when the availability status changes.
 */
public interface CIBAvailabilityStatusState
    extends CIBState {

  /**
   * Indicates that the managed object is in RUNNING state and perform normally.
   */
  public static final int NORMAL = 5;

  /**
   * Indicates that the managed object is experiencing degraded operating conditions
   * due to a high rate of errors.
   * On entering this state the managed object may generate an event.
   * Support of the DEGRADED state is optional for the managed objects implementing
   * the StateManageable model.
   */
  public static final int DEGRADED = 6;

  /**
   * Indicates that the managed object is experiencing degraded operating conditions
   * due to an overload. On entering this state the managed object may generate an event.
   * Support of the CONGESTED state is optional for the managed objects implementing
   * the StateManageable model.
   */
  public static final int CONGESTED = 7;

  /**
   * Returns the time the managed object has entered a degraded operational status
   * state (i.e. DEGRADED or CONGESTED operational status)
   * represented as a long, which value is the number of milliseconds since
   * January 1, 1970, 00:00:00.
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return long
   */
  public long getDegradedTime() throws CIBIOException,
      CIBAttributeNotFoundException;
}
