/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBObjectNameMapFactory.java 1.12     04/08/17 SMI"
 *
 */

package com.sun.mfwk.cib.sdk.util;

import java.util.Map;
import java.util.Hashtable;

import javax.management.ObjectName;
import javax.management.MalformedObjectNameException;
import com.sun.mfwk.util.instrum.MfObjectNameFactory;

/**
 * Provides methods to build the mapping between the CIB providers and the instrumentation
 */
public class CIBObjectNameMapFactory {

  /**
   * Private constructor
   */

  private CIBObjectNameMapFactory() {
  }

  /**
   *
   * @param name ObjectName
   * @return Map
   */
  public static Map getCIBApplicationStateMap(ObjectName name) {

    // create the mapping tables
    Hashtable applicationMap = new Hashtable();

    applicationMap.put("AvailabilityState", name);
    applicationMap.put("AvailStateLastChange", name);
    applicationMap.put("DegradedTime", name);
    applicationMap.put("OperationalState", name);
    applicationMap.put("OpsStateLastChange", name);
    applicationMap.put("RunningTime", name);

    return applicationMap;

  }

  public static Map getCIBApplicationStateMap() throws
      MalformedObjectNameException {
    ObjectName objName = MfObjectNameFactory.getStatusName();
    return (getCIBApplicationStateMap(objName));
  }

  /**
   * Build a Map for the ObjectName
   * @param serviceName ObjectName
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBServiceStateMap(ObjectName serviceName) throws
      MalformedObjectNameException {
    // create the mapping tables
    Hashtable serviceMap = new Hashtable();

    serviceMap.put("AvailabilityState", serviceName);
    serviceMap.put("AvailStateLastChange", serviceName);
    serviceMap.put("DegradedTime", serviceName);
    serviceMap.put("OperationalState", serviceName);
    serviceMap.put("OpsStateLastChange", serviceName);
    serviceMap.put("RunningTime", serviceName);

    return serviceMap;
  }

  /**
   * Build a Map for the CIBServicePerfStats
   * @param name String
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBServiceStateMap(String name) throws
      MalformedObjectNameException {

    ObjectName serviceName = MfObjectNameFactory.getTransactionMetricsName(name);
    return (getCIBServiceStateMap(serviceName));
  }

  /**
   * Build a Map for the CIBService
   * @param serviceName ObjectName
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBServicePerfStatsMap(ObjectName serviceName) throws
      MalformedObjectNameException {

    // create the mapping tables
    Hashtable serviceMap = new Hashtable();

    serviceMap.put("AccumulatedResponseTime", serviceName);
    serviceMap.put("AccumulatedServiceTime", serviceName);
    serviceMap.put("AccumulatedSqResponseTime", serviceName);
    serviceMap.put("AccumulatedSqServiceTime", serviceName);
    serviceMap.put("MaxResponseTime", serviceName);
    serviceMap.put("MaxServiceTime", serviceName);
    serviceMap.put("MinResponseTime", serviceName);
    serviceMap.put("MinServiceTime", serviceName);
    serviceMap.put("NbAccessResponseTime", serviceName);
    serviceMap.put("NbAccessServiceTime", serviceName);
    serviceMap.put("NbFailedRequests", serviceName);
    serviceMap.put("NbInRequests", serviceName);
    serviceMap.put("NbOutRequests", serviceName);
    serviceMap.put("NbAbortedRequests", serviceName);
    serviceMap.put("SingleAccumulatedServiceTime", serviceName);
    serviceMap.put("SingleAccumulatedSqServiceTime", serviceName);
    serviceMap.put("SingleMaxServiceTime", serviceName);
    serviceMap.put("SingleMinServiceTime", serviceName);
    serviceMap.put("SingleNbAccessServiceTime", serviceName);
    serviceMap.put("SingleNbFailedRequests", serviceName);
    serviceMap.put("Uri", serviceName);
    serviceMap.put("disableMonitoring", serviceName);
    serviceMap.put("enableMonitoring", serviceName);
    serviceMap.put("isMonitoringEnabled", serviceName);
    serviceMap.put("resetMetrics", serviceName);

    return serviceMap;

  }

  /**
   * Build a Map for the CIBServicePerfStats
   * @param name String
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBServicePerfStatsMap(String name) throws
      MalformedObjectNameException {

    ObjectName serviceName = MfObjectNameFactory.getTransactionMetricsName(name);
    return (getCIBServicePerfStatsMap(serviceName));
  }

  /**
   * Build a Map for the CIBExternalResourcePerfStats
   * @param name String
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBExternalResourcePerfStatsMap(String name) throws
      MalformedObjectNameException {
    ObjectName extResourceName = MfObjectNameFactory.
        getExternalResourceMetricsName(name);
    return (getCIBExternalResourcePerfStatsMap(extResourceName));
  }

  /**
   * Build a Map for a CIBExternalResource
   * @param extResourceName ObjectName
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBExternalResourcePerfStatsMap(ObjectName
      extResourceName) throws
      MalformedObjectNameException {

    Hashtable extResourceMap = new Hashtable();
    extResourceMap.put("AccumulatedOutboundAssociations", extResourceName);
    extResourceMap.put("AccumulatedQueriesTime", extResourceName);
    extResourceMap.put("AccumulatedSqQueriesTime", extResourceName);
    extResourceMap.put("FailedOutboundAssociations", extResourceName);
    extResourceMap.put("FailedQueries", extResourceName);
    extResourceMap.put("LastOutboundActivity", extResourceName);
    extResourceMap.put("MaxQueriesTime", extResourceName);
    extResourceMap.put("MinQueriesTime", extResourceName);
    extResourceMap.put("NbQueries", extResourceName);
    extResourceMap.put("OutboundAssociations", extResourceName);
    extResourceMap.put("disableMonitoring", extResourceName);
    extResourceMap.put("enableMonitoring", extResourceName);
    extResourceMap.put("isMonitoringEnabled", extResourceName);
    extResourceMap.put("resetMetrics", extResourceName);

    return extResourceMap;

  }

  /**
   *
   * @param name String
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBExternalResourceStateMap(String name) throws
      MalformedObjectNameException {
    ObjectName extResourceName = MfObjectNameFactory.
        getExternalResourceMetricsName(name);
    return (getCIBExternalResourceStateMap(extResourceName));
  }

  /**
   *
   * @param extResourceName ObjectName
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBExternalResourceStateMap(ObjectName
      extResourceName) throws
      MalformedObjectNameException {

    Hashtable extResourceMap = new Hashtable();
    extResourceMap.put("AvailabilityState", extResourceName);
    extResourceMap.put("AvailStateLastChange", extResourceName);
    extResourceMap.put("DegradedTime", extResourceName);
    extResourceMap.put("OperationalState", extResourceName);
    extResourceMap.put("OpsStateLastChange", extResourceName);
    extResourceMap.put("RunningTime", extResourceName);

    return extResourceMap;

  }

  /**
   * @param name String
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBResourcePerfStatsMap(String name) throws
      MalformedObjectNameException {
    ObjectName resourceName = MfObjectNameFactory.getResourceMetricsName(name);
    return (getCIBResourcePerfStatsMap(resourceName));
  }

  /**
   * @param resourceName ObjectName
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBResourcePerfStatsMap(ObjectName resourceName) throws
      MalformedObjectNameException {

    Hashtable resourceMap = new Hashtable();
    resourceMap.put("AccumulatedOperationTime", resourceName);
    resourceMap.put("AccumulatedSqOperationTime", resourceName);
    resourceMap.put("FailedOperations", resourceName);
    resourceMap.put("MaxOperationTime", resourceName);
    resourceMap.put("MinOperationTime", resourceName);
    resourceMap.put("NbOperations", resourceName);
    resourceMap.put("disableMonitoring", resourceName);
    resourceMap.put("enableMonitoring", resourceName);
    resourceMap.put("isMonitoringEnabled", resourceName);
    resourceMap.put("resetMetrics", resourceName);
    return resourceMap;

  }

  /**
   * @param name String
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBResourceStateMap(String name) throws
      MalformedObjectNameException {
    ObjectName resourceName = MfObjectNameFactory.getResourceMetricsName(name);
    return (getCIBResourceStateMap(resourceName));
  }

  /**
   *
   * @param resourceName ObjectName
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBResourceStateMap(ObjectName resourceName) throws
      MalformedObjectNameException {

    Hashtable resourceMap = new Hashtable();
    resourceMap.put("AvailabilityState", resourceName);
    resourceMap.put("AvailStateLastChange", resourceName);
    resourceMap.put("DegradedTime", resourceName);
    resourceMap.put("OperationalState", resourceName);
    resourceMap.put("OpsStateLastChange", resourceName);
    resourceMap.put("RunningTime", resourceName);
    return resourceMap;
  }

  /**
   * Returns a Map
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBApplicationConfigMap() throws
      MalformedObjectNameException {

    ObjectName configName = MfObjectNameFactory.getInstrumConfigName();
    return getCIBApplicationConfigMap(configName);
  }

  /**
   * Returns a Map
   * @param configName ObjectName
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBApplicationConfigMap(ObjectName configName) throws
      MalformedObjectNameException {

    Hashtable configMap = new Hashtable();
    configMap.put("AppDirectoryDN", configName);
    configMap.put("AppRole", configName);
    configMap.put("AppURLDescription", configName);
    return configMap;
  }

  /**
   * Return a Map
   * @param name String
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBServiceConfigMap(String name) throws
      MalformedObjectNameException {

    ObjectName configName = MfObjectNameFactory.getTransactionMetricsName(name);
    return getCIBServiceConfigMap(configName);
  }

  /**
   * Return a Map
   * @param configName ObjectName
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBServiceConfigMap(ObjectName configName) throws
      MalformedObjectNameException {

    Hashtable configMap = new Hashtable();
    configMap.put("Uri", configName);
    return configMap;
  }

  /**
   *
   * @param name String
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBExternalResourceConfigMap(String name) throws
      MalformedObjectNameException {

    ObjectName configName = MfObjectNameFactory.getExternalResourceMetricsName(
        name);
    return getCIBExternalResourceConfigMap(configName);
  }

  /**
   * Returns a Map
   * @param configName ObjectName
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBExternalResourceConfigMap(ObjectName configName) throws
      MalformedObjectNameException {

    Hashtable configMap = new Hashtable();
    configMap.put("ProviderUri", configName);
    return configMap;
  }

  /**
   * Returns a Map
   * @param name String
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getCIBResourceConfigMap(String name) throws
      MalformedObjectNameException {

    ObjectName configName = MfObjectNameFactory.getResourceMetricsName(name);
    return getCIBResourceConfigMap(configName);
  }

  /**
   * Returns a Map
   * @param configName ObjectName
   * @throws MalformedObjectNameException
   * @return Map
   */

  public static Map getCIBResourceConfigMap(ObjectName configName) throws
      MalformedObjectNameException {
    Hashtable configMap = new Hashtable();
    return configMap;
  }

  /**
   *
   * @throws MalformedObjectNameException
   * @return Map
   */
  public static Map getInstrumManagementMap() throws
      MalformedObjectNameException {

    Hashtable mgtMap = new Hashtable();
    ObjectName mgtName = MfObjectNameFactory.getInstrumManagementName();
    mgtMap.put("disableMonitoring", mgtName);
    mgtMap.put("enableMonitoring", mgtName);
    mgtMap.put("LoggingLevel", mgtName);
    mgtMap.put("isMonitoringEnabled", mgtName);
    return mgtMap;
  }

}
