/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBStatisticImpl.java 1.11     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib.sdk.statistics;

import java.sql.Timestamp;
import java.util.logging.Logger;
import com.sun.mfwk.util.log.MfLogService;

import com.sun.mfwk.cib.statistics.CIBStatistic;

/**
 * Provides a default implementation of a CIBStatistic
 */
public abstract class CIBStatisticImpl
    implements CIBStatistic {

  static final Logger logger = MfLogService.getLogger("cib-sdk");
  static final String className = "CIBStatisticImpl";
  static final String strSeparator = "\n";

  protected static long RESET_VALUE = -1;

  // Attributes
  private String myName;
  private String myDescription;
  private String myUnit;
  private long myLastSampleTime = RESET_VALUE;
  private long myStartTime = RESET_VALUE;

  /**
   * Contructor
   * @param name String
   * @param description String
   * @param unit String
   */
  public CIBStatisticImpl(String name, String description, String unit) {
    myName = name;
    myDescription = description;
    myUnit = unit;
    logger.exiting(className, "Constructor");

  }

  /**
   * Set the lastSampleTime of the statistic object
   * @param sampleTime long
   */
  public void setLastSampleTime(long sampleTime) {
    logger.entering(className, "setLastSampleTime", new Long(myLastSampleTime));
    myLastSampleTime = sampleTime;
    logger.exiting(className, "setLastSampleTime");
  }

  /**
   * Set the startTime of the statistic object representing the time of the beginning of
   * measurement
   * @param startTime long
   */
  public void setStartTime(long startTime) {
    logger.entering(className, "setStartTime", new Long(myStartTime));
    myStartTime = startTime;
    logger.exiting(className, "setStartTime");
  }

  /**
   * Get the name of the statistic object
   * @return String
   */
  public String getName() {
    logger.exiting(className, "getName", myName);
    return myName;
  }

  /**
   * Get the Unit of the statistic object
   * @return String
   */
  public String getUnit() {
    logger.exiting(className, "getUnit", myUnit);
    return myUnit;
  }

  /**
   * Get the description of the statistic object
   * @return String
   */
  public String getDescription() {
    logger.exiting(className, "getDescription", myDescription);
    return myDescription;
  }

  /**
   * Get the startTime of the statistic object
   * @return long
   */
  public long getStartTime() {
    logger.exiting(className, "getStartTime", new Long(myStartTime));
    return myStartTime;
  }

  /**
   * Get the lastSampleTime of the statistic object
   * @return long
   */
  public long getLastSampleTime() {
    logger.exiting(className, "getLastSampleTime", new Long(myLastSampleTime));
    return myLastSampleTime;
  }

  /**
    * Reset the statistic object
    */
  public void reset() {
    logger.entering(className, "reset");
    myLastSampleTime = RESET_VALUE;
    myStartTime = RESET_VALUE;
    logger.exiting(className,"reset");
  }

  /**
  * Returns a printable statistic object
  * @return String
  */
  public String toString() {

    Timestamp startTime = new Timestamp(this.getStartTime());
    Timestamp lastSampleTime = new Timestamp(this.getLastSampleTime());
    String strName = "Name="+this.getName()+strSeparator;
    String strUnit = "Unit="+this.getUnit()+strSeparator;
    String strDesc = "Description=" + this.getDescription()+strSeparator;
    String strStartTime = "StartTime="+startTime.toString()+strSeparator;
    String strLastSampleTime = "LastSampleTime="+lastSampleTime.toString()+strSeparator;

    return new String(strName+strUnit+strDesc+strStartTime+strLastSampleTime);
  }
}
