/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBServiceOperationalStatusImpl.java 1.9     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib.sdk.states;

// jdk
import java.util.Map;
import java.util.logging.Logger;

// Java ES-MF sdk
import com.sun.mfwk.cib.sdk.util.CIBObjectNameMapFactory;
import com.sun.mfwk.util.log.MfLogService;

// jmx
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/**
 * Provides default implementation of an operational status State provider for
 * a CIBService.
 * This implementation is fully based on the Java-ES MF Instrumentation SDK.
 */
public class CIBServiceOperationalStatusImpl
    extends CIBOperationalStatusStateImpl {

  static final Logger logger = MfLogService.getLogger("cib-sdk");
  static final String className = "CIBServiceOperationalStatusImpl";

  /**
   * Contructor
   * @param connection MBeanServerConnection
   * @param map Map
   */
  public CIBServiceOperationalStatusImpl(MBeanServerConnection connection,
                                         Map map) {
    super(connection, map);
  }

  /**
   * Contructor
   * @param connection MBeanServerConnection
   * @param name String
   */
  public CIBServiceOperationalStatusImpl(MBeanServerConnection connection,
                                         String name) throws
      MalformedObjectNameException {
    super(connection, CIBObjectNameMapFactory.getCIBServiceStateMap(name));
  }

  /**
   * Contructor
   * @param connection MBeanServerConnection
   * @param name ObjectName
   * @throws MalformedObjectNameException
   */
  public CIBServiceOperationalStatusImpl(MBeanServerConnection connection,
                                         ObjectName name) throws
      MalformedObjectNameException {
    super(connection, CIBObjectNameMapFactory.getCIBServiceStateMap(name));
  }
}
