/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBApplicationOperationalStatusImpl.java 1.10     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib.sdk.states;

// jdk
import java.util.Map;
import java.util.logging.Logger;

// Java ES-MF sdk
import com.sun.mfwk.cib.sdk.util.CIBObjectNameMapFactory;
import com.sun.mfwk.util.log.MfLogService;

// jmx
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/**
 * Provides default implementation of an operational status State provider for
 * a CIBApplication.
 * This implementation is fully based on the Java-ES MF Instrumentation SDK.
 */
public class CIBApplicationOperationalStatusImpl
    extends CIBOperationalStatusStateImpl {

  static final Logger logger = MfLogService.getLogger("cib-sdk");
  static final String className = "CIBApplicationOperationalStatusImpl";

  /**
   * Contructor
   * @param connection MBeanServerConnection
   * @param map Map
   */
  public CIBApplicationOperationalStatusImpl(MBeanServerConnection connection,
                                             Map map) {
    super(connection, map);
  }

  /**
   * Contructor
   * @param connection MBeanServerConnection
   */
  public CIBApplicationOperationalStatusImpl(MBeanServerConnection connection) throws
      MalformedObjectNameException {
    super(connection, CIBObjectNameMapFactory.getCIBApplicationStateMap());
  }

}
