/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBProviderHandler.java 1.18     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib.providers;

// CIB
import com.sun.mfwk.cib.CIBMonitoredObjectMBean;
import com.sun.mfwk.cib.statistics.CIBPerfStats;
import com.sun.mfwk.cib.states.CIBOperationalStatusState;
import com.sun.mfwk.cib.states.CIBAvailabilityStatusState;
import com.sun.mfwk.cib.CIBAttributeNotFoundException;
import com.sun.mfwk.cib.CIBException;
import com.sun.mfwk.cib.CIBIOException;
import com.sun.mfwk.cib.CIBProviderNotFoundException;
import com.sun.mfwk.cib.config.CIBConfiguration;

// Jmx
import javax.management.JMException;

/**
 * Provides methods that should be implemented by a CIBProviderHandler
 */
public interface CIBProviderHandler {

  /**
   * Type of an CIBApplicationPerfStats provider
   */
  public static final int APPLICATION_PERFSTATS_TYPE = 1;

  /**
   * Type of an CIBServicePerfStats provider
   */
  public static final int SERVICE_PERFSTATS_TYPE = 2;

  /**
   * Type of an CIBExternalServicePerfStats provider
   */
  public static final int EXTERNALRESOURCE_PERFSTATS_TYPE = 3;

  /**
   * Type of an CIBResourcePerfStats provider
   */
  public static final int RESOURCE_PERFSTATS_TYPE = 4;

  /**
   * Type of an CIBState for a CIBApplication
   */
  public static final int APPLICATION_STATE_TYPE = 11;

  /**
   * Type of an CIBState for a CIBService
   */
  public static final int SERVICE_STATE_TYPE = 12;

  /**
   * Type of an CIBState for a CIBExternalResource
   */
  public static final int EXTERNALRESOURCE_STATE_TYPE = 13;

  /**
   * Type of an CIBState for a CIBResource
   */
  public static final int RESOURCE_STATE_TYPE = 14;

  /**
   * Type of an CIBConfiguration for a CIBApplication
   */
  public static final int APPLICATION_CONFIG_TYPE = 21;

  /**
   * Type of an CIBConfiguration for a CIBService
   */
  public static final int SERVICE_CONFIG_TYPE = 22;

  /**
   *  Type of an CIBConfiguration for a CIBExternalResource
   */
  public static final int EXTERNALRESOURCE_CONFIG_TYPE = 23;

  /** Type of an CIBConfiguration for a CIBResource
   */
  public static final int RESOURCE_CONFIG_TYPE = 24;

  /**
   * Creates the providers
   * @param monitoredObject CIBMonitoredObjectMBean
   * @throws CIBException
   * @throws JMException
   */
  public void createProviders(CIBMonitoredObjectMBean monitoredObject) throws
      CIBException, JMException;

  /**
   * Returns the CIBPerfStats object associated to a monitored object
   * @param monitoreObject CIBMonitoredObjectMBean
   * @param statsType int
   * @throws CIBIOException
   * @throws CIBProviderNotFoundException
   * @throws CIBAttributeNotFoundException
   * @return CIBPerfStats
   */
  public CIBPerfStats getPerfStats(CIBMonitoredObjectMBean monitoreObject,
                                   int statsType) throws CIBIOException,
      CIBProviderNotFoundException, CIBAttributeNotFoundException;

  /**
   * Returns the CIBOperationalStatusState object associated to the monitored object
   * @param monitoreObject CIBMonitoredObjectMBean
   * @param stateType int
   * @throws CIBIOException
   * @throws CIBProviderNotFoundException
   * @throws CIBAttributeNotFoundException
   * @return CIBOperationalStatusState
   */
  public CIBOperationalStatusState getOperationalStatusState(
      CIBMonitoredObjectMBean monitoreObject, int stateType) throws
      CIBIOException, CIBProviderNotFoundException,
      CIBAttributeNotFoundException;

  /**
   * Returns the CIBAvailabilityStatusState object associated to the monitored object
   * @param monitoreObject CIBMonitoredObjectMBean
   * @param stateType int
   * @throws CIBIOException
   * @throws CIBProviderNotFoundException
   * @throws CIBAttributeNotFoundException
   * @return CIBAvailabilityStatusState
   */
  public CIBAvailabilityStatusState getAvailabilityStatusState(
      CIBMonitoredObjectMBean monitoreObject, int stateType) throws
      CIBIOException, CIBProviderNotFoundException,
      CIBAttributeNotFoundException;

  /**
   * Returns the CIBConfiguration object of the associated monitored object
   * @param monitoreObject CIBMonitoredObjectMBean
   * @param configType int
   * @throws CIBIOException
   * @throws CIBProviderNotFoundException
   * @throws CIBAttributeNotFoundException
   * @return CIBConfiguration
   */
  public CIBConfiguration getConfiguration(CIBMonitoredObjectMBean
                                           monitoreObject, int configType) throws
      CIBIOException, CIBProviderNotFoundException,
      CIBAttributeNotFoundException;

}
