/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBProvider.java 1.12     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib.providers;

import com.sun.mfwk.cib.CIBException;
import com.sun.mfwk.cib.CIBIOException;

/**
 * Provides methods that should be implemented by a CIBProvider
 */
public interface CIBProvider {

  /**
   * Initialize the provider mechanism. In particular, initialize the
   * communication to the instrumentation layer. This method is called
   * by the MBean and/or the CIBProviderHandler to initialize the provider
   * @throws CIBIOException
   * @throws CIBException
   */
  public void init() throws CIBIOException, CIBException;

  /**
   * Destroy the each created objects and clean the objects/values
   * when needed, close all the communications. This method is called by the MBean
   * and/or the CIBProviderHandler to clean the provider.
   * @throws CIBIOException
   * @throws CIBException
   */
  public void destroy() throws CIBIOException, CIBException;
}
