/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBExternalResourceConfiguration.java 1.5     04/06/29 SMI"
 *
 */

package com.sun.mfwk.cib.config;

//cib
import com.sun.mfwk.cib.CIBIOException;
import com.sun.mfwk.cib.CIBAttributeNotFoundException;

/**
 * Provides interfaces that should be implemented by each provider providing
 * CIB ExternalResource configuration attributes.
 * The attribute that should be exposed is : providerUri
 */
public interface CIBExternalResourceConfiguration
    extends CIBConfiguration {

  /**
   * Get the provider Uri
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return String
   */
  public String getProviderUri() throws CIBIOException,
      CIBAttributeNotFoundException;

}
