/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBServiceMBean.java 1.18     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

import javax.management.ObjectName;
import javax.management.InvalidAttributeValueException;

/**
 * Provides methods that should be implemented by a CIBService MBean
 * The CIBService is the base object model to describe the Network Service Access Point(s)
 * of an application.
 * A CIBService managed object is characterized by the Uniform Resource Identifier (URI)
 * descriptor of its NSAP.
 */
public interface CIBServiceMBean
    extends CIBMonitoredObjectMBean {

  /**
   * Provides the service name identified by its URI
   * @return String
   */
  public String getUri() throws InvalidAttributeValueException;

  /**
   * Returns the name of the Related CIBApplication
   * @return ObjectName
   */
  public ObjectName getApplication()  throws InvalidAttributeValueException;
  /**
   * Returns the name of each related CIBRessources
   * @return ObjectName[]
   */
  public ObjectName[] getResources() ;

  /**
  * Return the list of External resource object names associated to the service
  * @return ObjectName[]
  */
 public ObjectName[] getExternalResources();

 /**
  * Returns the object name of a ExternalResource associated to the service
  * identifies by its Uri
  * @param uri String
  * @return ObjectName
  */
 public ObjectName getExternalResourceByUri(String uri) throws CIBException;

}
