/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBServiceIf.java 1.16     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

import javax.management.ObjectName;

/**
 * Provides methods that should be implemented by a CIBService managed object
 */
public interface CIBServiceIf
    extends CIBMonitoredObjectIf {

  /**
   * Allows to set the application object Name to which the CIBService is
   * running
   * @param objectName ObjectName
   */
  public void setCIBApplication(ObjectName objectName);

  /**
   * Set the Uri of the services
   * @param theUri String
   */
  public void setUri(String theUri);

  /**
   * Allows to add a CIBReource objectName in the list
   * of reosurce managed object linked to the service
   * @param objectName ObjectName
   */
  public void addCIBResource(ObjectName objectName);

  /**
   * Allows to remove a CIBResource object name from the list associated
   * to the service
   * @param objectName ObjectName
   */
  public void removeCIBResource(ObjectName objectName) throws CIBException;

  /**
    * Allows to add an CIBExternalResource to the list of ConsumedServices
    * @param objectName ObjectName
    */
   public void addCIBExternalResource(ObjectName objectName);

   /**
    * Allows to remove an an CIBExternalService from the list of ConsumedServices
    * @param objectName ObjectName
    * @throws CIBException
    */
   public void removeCIBExternalResource(ObjectName objectName) throws
       CIBException;

}
