/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBResourceMBean.java 1.17     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

import javax.management.ObjectName;
import javax.management.InvalidAttributeValueException;

/**
 * Provides methods that should be implemented by a CIBResource
 * The CIBResource is the base object model to represent a software resource.
 * A software resource is embedded in an application's binary and provides consumable
 * items or computation services that the application uses to process requests.
 * Examples of a resource include the JVM, a connections pool, a cache, etc., .
 */
public interface CIBResourceMBean
    extends CIBMonitoredObjectMBean {

  /**
   * Provides the object name of the CIBApplication
   * @return ObjectName
   */
  public ObjectName getApplication();

  /**
   * Provides the object name of the CIBResource
   * @return ObjectName
   */
  public ObjectName getService();
}
