/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBProviderHandlerNotFoundException.java 1.7     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

import javax.management.ObjectName;

/**
 * Throws when the prvoder handler is not found
 */
public class CIBProviderHandlerNotFoundException
    extends CIBException {

  /**
   * Build an exception with the Mbean objectName
   * @param mbean ObjectName
   */
  public CIBProviderHandlerNotFoundException(ObjectName mbean) {
    super(mbean.toString());
  }

  /**
   * Build an exception with a detailed message and the mbean name
   * @param message String
   * @param mbean ObjectName
   */
  public CIBProviderHandlerNotFoundException(String message, ObjectName mbean) {
    super(mbean.toString() + "-" + message);
  }

  /**
   * Build an exception with the throwable
   * @param mbean ObjectName
   * @param cause Throwable
   */
  public CIBProviderHandlerNotFoundException(ObjectName mbean, Throwable cause) {
   super(mbean.toString(), cause);
 }

 /**
  * build a new CIBProviderHandlerNotFoundException with the detailed message and the nested throwable
   * @param message String
   * @param mbean ObjectName
   * @param cause Throwable
   */
  public CIBProviderHandlerNotFoundException(String message, ObjectName mbean,
                                     Throwable cause) {
   super(mbean.toString() + "-" + message, cause);
 }
}
