/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBProductIf.java 1.14     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

import javax.management.ObjectName;

/**
 * Provides methods that should be implemented by a CIBProduct managed object
 */
public interface CIBProductIf {

  /**
   * Add an application ObjectName into the CIBProduct object.
   * @param applObjectName ObjectName
   */
  public void addApplication(ObjectName applObjectName);

  /**
   * remove an application object name from the CIBProduct
   * @param applObjectName ObjectName
   */
  public void removeApplication(ObjectName applObjectName) throws CIBException;

  /**
   * Allows to set the product Name of the product
   * @param productName String
   */
  public void setProductName(String productName);

 /**
   * Allow to set the version of the product
   * @param productVersion String
   */
  public void setVersion(String productVersion);

  /**
   * Allow to set the patchId
   * @param productPatchId String
   */
  public void setPatchId(String productPatchId);

  /**
   * Allow to set the installtime date
   * @param date long
   */
  public void setInstallTime(long date);

  /**
   * Allow to set the vendor name
   * @param vendorName String
   */
  public void setVendorName(String vendorName);
}
