/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBObject.java 1.25     04/08/06 SMI"
 *
 */

package com.sun.mfwk.cib;

import com.sun.mfwk.cib.CIBObjectMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.ObjectName;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;

// JESMF log
import java.util.logging.*;
import com.sun.mfwk.util.log.MfLogService;

/**
 * Default implementation of a CIB Object MBean.
 */
public class CIBObject
    implements CIBObjectMBean, MBeanRegistration {

  // Keys for CIB objects
  private static final String CIB_KEY_TYPE = "type";
  private static final String CIB_KEY_NAME = "name";   
  
  // MBeanServer communication attributes
  protected MBeanServer mbeanServer = null;
  protected boolean isRegistered = false;

  protected static final Logger CIBMbeanLogger = MfLogService.getLogger(
      "cib_mbean");
  protected static final String CIBMbeanLogMessageHeaderString =
      " *** CIB MBean Implementation log :\n";
  protected static final String CIBMbeanLogMessageClosingString =
      " *** end CIB MBean Implementation log \n";
  protected static final String CIBMbeanNewLine = "\n";

  protected static final String FORBIDEN_NULL_VALUE =
      " Null value is invalid for attribute : ";

  protected ObjectName objectName = null;

  protected CIBObject() {
  }

  /**
   * Returns the model version
   * @return String
   */
  public String getModelVersion() {
    return ModelVersion;
  }

  /**
   * Returns the "name" of the object. The "name=value" part of the ObjectName
   * @return String
   */
  public String getName() throws InvalidAttributeValueException {
    if (objectName == null) {
      return null;
    }
    else {
      try {
        String name = objectName.getKeyProperty(CIB_KEY_NAME);
        return name;
      }
      catch (NullPointerException ne) {
        CIBMbeanLogger.warning(CIBMbeanLogMessageHeaderString +
                               "unset key-property " + CIB_KEY_NAME + " for CIBObject " +
                               this + CIBMbeanNewLine +
                               CIBMbeanLogMessageClosingString);
        throw new InvalidAttributeValueException(FORBIDEN_NULL_VALUE + CIB_KEY_NAME);
      }
    }
  }

  /**
   * Return the "type" of the object, as found in the "type=value" 
   * keyproperty of the ObjectName
   * @return String
   */
  public String getType() throws InvalidAttributeValueException {

    if (objectName == null) return null;
    else {
      try {
          String type = objectName.getKeyProperty(CIB_KEY_TYPE);
          return type;
        }
      catch (NullPointerException ne) {
        CIBMbeanLogger.warning(CIBMbeanLogMessageHeaderString +
                               "unset key-property " + CIB_KEY_TYPE + " for CibObject " +
                               this + CIBMbeanNewLine +
                               CIBMbeanLogMessageClosingString);
        throw new InvalidAttributeValueException(FORBIDEN_NULL_VALUE + CIB_KEY_TYPE);
      }
    }
  }

  //////////////////////////////////////////////////
 //
 // Implementation of MBeanRegistration interface
 //
 //////////////////////////////////////////////////

 // no deregistration action
 public synchronized void preDeregister() {}

 public void postDeregister() {
   mbeanServer = null;
   objectName = null;
   isRegistered = false;
 }

 public synchronized void postRegister(Boolean registrationDone) {
   if (registrationDone.booleanValue() == true) {
     isRegistered = true;
   }
   else {
     isRegistered = false;
     mbeanServer = null;
   }
 }

 public synchronized ObjectName preRegister(MBeanServer server,
                                            ObjectName name) {
   mbeanServer = server;
   objectName = name;
   return name;
 }
}
