/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBMonitoredObjectIf.java 1.16     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

import com.sun.mfwk.cib.providers.CIBProviderHandler;

/**
 * Provides methods that should be implemented by a CIBMonitoredObject managed object
 */
public interface CIBMonitoredObjectIf extends CIBManagedObjectIf {

  /**
   * Returns the CIBProviderHandler object
   * @return CIBProviderHandler
   */
  public CIBProviderHandler getCIBProviderHandler() throws CIBProviderHandlerNotFoundException;

  /**
   * Set the CIB provider handler
   * @param providerHandler CIBProviderHandler
   */
  public void setCIBProviderHandler(CIBProviderHandler providerHandler);

}
