/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBManagedObjectMBean.java 1.14     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

import javax.management.InvalidAttributeValueException;

/**
 * Provides methods that should be implemented by each managed object
 * The CIBManagedObject is the base object model to support the dynamic logging management functions.
 * When the current specification is enhanced
 * to address more common management capabilities the CIBManagedObject model should be
 * extended accordingly.
 */
public interface CIBManagedObjectMBean
    extends CIBObjectMBean {

  /**
   * Returns a description for the Managed object
   */
  public String getDescription();

  /**
   * Returns true if the managed object is an Event Provider else returns false
   */
  public boolean isEventProvider();

  /**
   * Allows to switch On/Off the JMX event notifications from the managed object
   */
  public void setEventProvider(boolean isEventProvider);
}
