/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBIOException.java 1.8     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

/**
 * Throws when a communication problem occurs
 */
public class CIBIOException
    extends CIBException {

  /**
   * Contructs a new CIBIOException
   * @param providerClassName String
   */
  public CIBIOException(String providerClassName) {
    super(providerClassName);
  }

  /**
   * Contructs a new CIBIOException with the detailed message
   * @param message String
   * @param providerClassName String
   */
  public CIBIOException(String message, String providerClassName) {
    super(providerClassName + "-" + message);
  }

  /**
   * Constructs a new CIBAttributeNotFoundException with the detailed message and the nested throwable
   * @param providerClassName String
   * @param cause Throwable
   */
  public CIBIOException(String providerClassName, Throwable cause) {
    super(providerClassName, cause);
  }

  /**
   * Constructs a new CIBIOException with the detailed message and the nested throwable
   * @param message String
   * @param cause Throwable
   */
  public CIBIOException(String message, String providerClassName,
                        Throwable cause) {
    super(providerClassName + "-" + message, cause);
  }
}
