/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBExternalResourceMBean.java 1.19     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

import javax.management.ObjectName;
import javax.management.InvalidAttributeValueException;

/**
 * Provides methods that should be implemented by a CIBExternalService managed object to
 * expose its management attributes.
 * The CIBExternalService object model implements an association between an application
 * providing the remote service and the application consuming the remote service.
 * The association specifies the NSAP URI the consuming application depends on.
 */

public interface CIBExternalResourceMBean
    extends CIBMonitoredObjectMBean {

  /**
   * Provides the Associated Service URI
   * @return String
   */

  public String getProviderUri() throws InvalidAttributeValueException;

  /**
   *  Returns the name of the CIBApplication
   * @return ObjectName
   */
  public ObjectName getApplication() throws InvalidAttributeValueException;

  /**
   *  Returns the name of the CIBService
   * @return ObjectName
   */
  public ObjectName getService() throws InvalidAttributeValueException;

}
