/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBAttributeNotFoundException.java 1.8     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

/**
 * Throws when a attribute is not found by the provider
 */
public class CIBAttributeNotFoundException
    extends CIBException {

  /**
   * Contructs a new CIBAttributeNotFoundException
   * @param providerClassName String
   * @param attributeName String
   */
  public CIBAttributeNotFoundException(String providerClassName,
                                       String attributeName) {
    super(providerClassName + ":" + attributeName);
  }

  /**
   * Contructs a new CIBAttributeNotFoundException with the detailed message
   * @param message String
   * @param providerClassName String
   * @param attributeName String
   */
  public CIBAttributeNotFoundException(String message, String providerClassName,
                                       String attributeName) {
    super(providerClassName + ":" + attributeName + "-" + message);
  }

  /**
   * Constructs a new CIBAttributeNotFoundException with the detailed message and the nested throwable
   * @param providerClassName String
   * @param attributeName String
   * @param cause Throwable
   */
  public CIBAttributeNotFoundException(String providerClassName,
                                       String attributeName, Throwable cause) {
    super(providerClassName + ":" + attributeName, cause);
  }

  /**
   * Constructs a new CIBAttributeNotFoundException with the detailed message and the nested throwable
   * @param message String
   * @param providerClassName String
   * @param attributeName String
   * @param cause Throwable
   */
  public CIBAttributeNotFoundException(String message, String providerClassName,
                                       String attributeName, Throwable cause) {
    super(providerClassName + ":" + attributeName + "-" + message, cause);
  }

}
