/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)mfTransactionPrivate.h 1.8     04/05/19 SMI"
 *
 */


#define MIN(a,b) (((a)<=(b) ? (a):(b)))
#define MAX(a,b) (((a)>=(b) ? (a):(b)))

#if defined(DEBUG_BUILD)  
   #define DEBUG_PRINTF(tranid,fs,a1,a2,a3,a4) \
            debug_printf(tranid,fs, a1, a2, a3, a4)  
#else
   #define DEBUG_PRINTF(tranid,fs,a1,a2,a3,a4)
#endif

#define LIBNAME "libmfTransaction"
#define MF_INSTRUM_VERSION_STRING "1.0 Build 1"

#define MF_UNDEFINED_TRAN_ID 666
typedef enum{
  ONETXN_STATE_NOT_STARTED, /* just initialialized */
	ONETXN_STATE_TICKING,   /* start() call done */
	ONETXN_STATE_PAUSED,    /* block() call done */
	ONETXN_STATE_STOPPED      /* stop() call done */
}onetxn_state_t;

typedef struct one_transaction_info one_transaction_info_t;
typedef struct transaction_type_info transaction_type_info_t;

struct one_transaction_info{

  /* Pointer back to the global info for this transaction type, to which
	 this structure is a contributor.
  */
  transaction_type_info_t *onetxn_txntypep;
  onetxn_state_t onetxn_state;
  /* response time data */
  PRIntervalTime onetxn_start; 
  /* cpu time data */
  long long onetxn_cputime_start;  
  long long onetxn_blocked_cputime_start;  
  long long onetxn_accumulated_blocked_cputime;
  int onetxn_status;             /* status OK, failure   (1byte)   */
  one_transaction_info_t *onetxn_next_txnp;
};
 
typedef struct onetxn_list{
  one_transaction_info_t *otl_listp;
  unsigned long otl_num_txns_in_list;
  unsigned long otl_num_active_txns;
  pthread_mutex_t otl_mutex;
}onetxn_list_t;

struct transaction_type_info {
  char txntype_name[MF_MAX_TXN_NAME_LEN + 1 ];
  mfTransactionMetrics_t *txntype_metricsp;
  pthread_mutex_t txntype_mutex_metrics;
  long long *txntype_is_monitoring_enabledp;
  /* XXX queue length
	 nb failed requests
  */
  /* At register_transaction_time() we prealloc
     a number of transaction objects.
     Then, if we pass that we will allocate more
  */
#define INITIAL_NUM_TXNS_PER_TXNTYPE 1000
  onetxn_list_t txntype_freelist;
};



/* txn_display.c */
#if defined(DEBUG_BUILD)

extern void txn_display_txn_types();
extern void txn_display_txn_type( transaction_type_info_t *txn_typep );
extern void txn_display_txns_needs_lock(
							one_transaction_info_t *txntype_onetxn_listp );
void debug_printf(int tran_id, char *fmt, ... );
extern pthread_mutex_t global_mutex_txn_display;

#endif

/**/
