/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)mfCserver.c 1.5     04/06/12 SMI"
 *
 */


/*
 * mfCserver.c - Connector server
 *                                                                  * 
 */
#include <pthread.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include <strings.h>

#include "mfConstant.h"
#include "mfRserver.h"



/* static variables */

static int connectorServerCreated = 0;       /* Connector server boolean flag */
static pthread_mutex_t mutexConnectorServer; /* connector server mutex */


/*port number */
int    portNumberCreated  = 0;        /* resource server boolean flag */
pthread_mutex_t mutexPortNumber;      /* mutex resource server */
pthread_cond_t  condPortNumber;       /* cond resource server */


int portNumber;



/* external procedure */
extern void *connectorserverthread(void *arg);
extern void init_jesmfcom();

#ifdef sun
#pragma init (init_jesmfcom)
#endif

#ifdef linux
__attribute__ ((constructor)) void init() {
    init_jesmfcom();

}
#endif


/*
 * Function: init_jesmfcom 
 *
 * This function is called when
 * the dynamic library is called 
 */
void init_jesmfcom()
{
  pthread_cond_init(&condPortNumber,NULL);
  DEBUG_PRINTF("init_jesmfcom done\n");
}


/*
 * Function: mfCreateConnectorServer 
 *
 * This function creates the connector server 
 * 
 *
 * returns code:
 *     MF_SUCCES  (success) 
 *     MF_EXIST   (resource server already exist)
 *     EAGAIN     (cf pthread ERRORS)
 *     EINVAL     (cf pthread ERRORS)
 *     EPERM      (cf pthread ERRORS)
 */
int mfCreateConnectorServer(int *freePortNumber) 
{

int rc;
  pthread_t tid_connectorserver;
 
  /* fix of bugId 525755
     application crashes when passing null 
     pointer
 */

  if (freePortNumber == NULL) {
    DEBUG_PRINTF("freeportNumber: null Param\n");
    return MF_NULL_PARAM;
  }

  pthread_mutex_lock(&mutexConnectorServer);
  
  if (connectorServerCreated == 0) {

    /* test if connector server already exists */
    pthread_mutex_lock(&mutexPortNumber);
    portNumberCreated = 0 ;
    pthread_mutex_unlock(&mutexPortNumber);

    rc = pthread_create(&tid_connectorserver, NULL, connectorserverthread,NULL);
  
    /* the thread has been succesfully createrd */
    if (rc == 0) 
      {
	pthread_mutex_lock(&mutexPortNumber);
	/* test if the port number is already set */
	if (portNumberCreated == 0) {
	  pthread_cond_wait(&condPortNumber,&mutexPortNumber);
	} 
  
	DEBUG_PRINTF2("cs : portnumber %d\n", portNumber);
    
	*freePortNumber = portNumber;
	pthread_mutex_unlock(&mutexPortNumber);
	connectorServerCreated = 1;
      }
    }
    else {
    rc = MF_CONNECTOR_SERVER_EXIST;
  }
  pthread_mutex_unlock(&mutexConnectorServer);
 
  return rc;
}
