/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)mfUtils.h 1.14     04/07/02 SMI"
 *
 */


/*
 * mfUtils.h - Utils header file
 * 
 */

#ifndef MF_UTILS_H_INCLUDED
#define MF_UTILS_H_INCLUDED

#include "mfConstant.h"
#include "mfRserver.h"

/*
   fix of bugId 5022188
   extern "C" missing in jesmf_com.h and jesmf_utils.

*/



#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


  typedef void resetFunc_t(void* );


 

  /*mfInstrumConfig_t match the java class mfInstrumConfig */
  typedef struct mfInstrumConfig{
    char  *AppDirectoryDN;
    char *AppRole;
    char *AppURLDescription;
  } mfInstrumConfig_t;

  /* mfInstrumManagement_t match the Java class mfInstrumManagement */
  typedef struct mfInstrumManagement{
    long long MonitoringEnabled;
    long long LoggingLevel;
  } mfInstrumManagement_t;



  /*  Theres is a 1 per 1 correspondance  
    between C typedef and Java util instrum
    classes.
   
    Although inheritance is not provided in 
    C, the structure herafter allows to respect
    The hierachy subclass which is defined in 
    Java abd respresented below
   
    mfStatus_t
       --> mfMetrics_t
                --> mfExternalResourceMetric_t
		--> mfResourceMetrics_t
		--> mfTransactionMetric_t

  */


  /*fix 5069911
    AvailabilityState becomes a long instead of long long
    OperationalState becomes a long instead of long long
  */



  /* mfStatus_t match the Java class MfStatus */ 
  typedef struct mfStatus{
    long AvailabilityState ;
    long long AvailStateLastChange ;
    long long DegradedTime ;
    long OperationalState ;
    long long OpsStateLastChange;
    long long RunningTime;
  } mfStatus_t;





  /*mfMetrics_t match the Java class mfMetric */
  typedef struct mfMetrics {
    long AvailabilityState ;
    long long AvailStateLastChange ;
    long long DegradedTime ;
    long OperationalState ;
    long long OpsStateLastChange;
    long long RunningTime;   
    long long isMonitoringEnabled;
    resetFunc_t *reset;
  } mfMetrics_t;



  /*mfExternalResourceMetrics_t match the 
    Java class mfExternalResourceMetric */
  typedef struct mfExternalResourceMetrics{
    long AvailabilityState ;
    long long AvailStateLastChange ;
    long long DegradedTime ;
    long OperationalState ;
    long long OpsStateLastChange;
    long long RunningTime;   
    long long isMonitoringEnabled;
    resetFunc_t *reset;

    long long AccumulatedOutboundAssociations;
    long long AccumulatedQueriesTime;
    long long AccumulatedSqQueriesTime;
    long long FailedOutboundAssociations;
    long long FailedQueries;
    long long LastOutboundActivity;
    long long MaxQueriesTime;
    long long MinQueriesTime;
    long long NbQueries;
    long long OutboundAssociations;
  } mfExternalResourceMetrics_t;


  /*mfResourceMetrics match the 
   Java class mfResourceMetric */
  /*fix bugId 5069916: Typo FailedOperaTion --> FailedOperations */
  typedef struct mfResourceMetrics{
    long AvailabilityState ;
    long long AvailStateLastChange ;
    long long DegradedTime ;
    long OperationalState ;
    long long OpsStateLastChange;
    long long RunningTime;   
    long long isMonitoringEnabled;
    resetFunc_t *reset;

    long long AccumulatedOperationTime;
    long long AccumulatedSqOperationTime;
    
    long long FailedOperations;
    long long MaxOperationTime;
    long long MinOperationTime;
    long long NbOperations;    
  } mfResourceMetrics_t;



 

  /*mfTransactionMetric_t match the 
  Java class mfTransactionMetric*/
  typedef struct mfTransactionMetrics{
    long AvailabilityState ;
    long long AvailStateLastChange ;
    long long DegradedTime ;
    long OperationalState ;
    long long OpsStateLastChange;
    long long RunningTime;   
    long long isMonitoringEnabled;
    resetFunc_t *reset;

    long long AccumulatedResponseTime;
    long long AccumulatedServiceTime;
    long long AccumulatedSqResponseTime;
    long long AccumulatedSqServiceTime;
    long long MaxResponseTime;
    long long MaxServiceTime;
    long long MinResponseTime;
    long long MinServiceTime;
    long long NbAbortedRequests;
    long long NbFailedRequests;
    long long NbInRequests;
    long long NbOutRequests;
    long long SingleAccumulatedServiceTime;
    long long SingleAccumulatedSqServiceTime;
    long long SingleMaxServiceTime;
    long long SingleMinServiceTime;
    long long SingleNbAbortedRequests;
    long long SingleNbFailedRequests;
    char *Uri;
  } mfTransactionMetrics_t;


 



  /* add listener function */

int mfAddInstrumManagementListener(mfResourceObject_t *resourceMetricsObject);

  /* reset functions */
resetFunc_t mfResetExternalResourceMetrics;
resetFunc_t mfResetResourceMetrics;
resetFunc_t mfResetTransactionMetrics;

  /* object name facory functions */
int mfGetExternalResourceMetricsName(char *name,char *objectName, int size);
int mfGetInstrumConfigName(char *objectName,int size);
int mfGetInstrumManagementName(char *objectName,int size);
int mfGetResourceMetricsName(char *name,char *objectName, int size );
int mfGetTransactionMetricsName(char *name, char *objectName, int size );

  /*callback functions */
#ifdef UNUSED 
getterFunc_t  mfCbGetSimpleResource;
#endif
getterFunc_t mfCbGetTransactionMetrics;
setterFunc_t mfCbSetTransactionMetrics;
#ifdef UNUSED 
setterFunc_t mfCbSetMetrics;
#endif
invokerFunc_t mfCbInvokeTransactionMetrics; 

getterFunc_t mfCbGetResourceMetrics; 
setterFunc_t mfCbSetResourceMetrics;
invokerFunc_t mfCbInvokeResourceMetrics;

getterFunc_t mfCbGetStatus; 
setterFunc_t mfCbSetStatus;
invokerFunc_t mfCbInvokeStatus;


getterFunc_t mfCbGetExternalResourceMetrics ; 
setterFunc_t mfCbSetExternalResourceMetrics;
invokerFunc_t mfCbInvokeExternalResourceMetrics;

getterFunc_t mfCbGetConfig; 
setterFunc_t mfCbSetConfig; 

getterFunc_t mfCbGetInstrumManagement ;
setterFunc_t mfCbSetInstrumManagement ; 
invokerFunc_t mfCbInvokeInstrumManagement ;

int mfRegisterStatus(/*in */  mfResourceObject_t *resourceObject,
		     /*in */  mfStatus_t *resourceStatus,
		     /*in */  int objectNameSize,
		     /*out */ char *objectName);

int mfRegisterResourceTransactionMetrics(/*in */  mfResourceObject_t *resourceObject,
					 /*in */  char *transactionTypeName,
					 /*in */  char *uri,
					 /*in */  mfTransactionMetrics_t *transactionMetrics,
					 /*in */  int objectNameSize,
					 /*out */ char *objectName,
					/*out */ unsigned short *transactionId );


int mfRegisterResourceMetrics(/*in */  mfResourceObject_t *resourceObject,
			     /*in */  char *name, 
			     /*in */  mfResourceMetrics_t *resourceMetric,
			     /*in */  int objectNameSize,
			     /*out */ char *objectName);


int mfRegisterExternalResourceMetrics(/*in */  mfResourceObject_t *resourceObject,
				     /*in */  char *name, 
				     /*in */  mfExternalResourceMetrics_t *externalResourceMetric,
				     /*in */  int objectNameSize,
				     /*out */ char *objectName);



int mfRegisterInstrumConfig(/*in */  mfResourceObject_t *resourceObject,
			   /*in */  void *resource,
			   /*in */  int objectNameSize,
			   /*out */ char *objectName);




int mfRegisterInstrumManagement(/*in */  mfResourceObject_t *resourceObject,
				/*in */  void *resource,
				/*in */  int objectNameSize,
				/*out */ char *objectName);


long long mfgetCurrentTimeMillis();

#ifdef __cplusplus
}
#endif /* __cplusplus */

       
#endif /* JESMF_H_INCLUDED */
